/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pdp.config;

import java.util.Collections;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.glite.authz.common.ServiceMetrics;
import org.glite.authz.common.config.AbstractServiceConfiguration;
import org.glite.authz.pdp.obligation.ObligationService;
import org.glite.authz.pdp.pip.PolicyInformationPoint;
import org.glite.authz.pdp.server.PDPMetrics;
import org.opensaml.ws.security.SecurityPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class PDPConfiguration
extends AbstractServiceConfiguration {
    private List<String> papEndpoints = null;
    private int policyRetentionInterval = 0;
    private String policySetId = null;
    private SecurityPolicy authzDecisionQuerySecurityPolicy = null;
    private List<PolicyInformationPoint> pips;
    private ObligationService obligationService;

    protected PDPConfiguration() {
        super((ServiceMetrics)new PDPMetrics());
    }

    public SecurityPolicy getAuthzDecisionQuerySecurityPolicy() {
        return this.authzDecisionQuerySecurityPolicy;
    }

    public List<String> getPAPEndpointss() {
        return this.papEndpoints;
    }

    public int getPolicyRetentionInterval() {
        return this.policyRetentionInterval;
    }

    public String getPolicySetId() {
        return this.policySetId;
    }

    public List<PolicyInformationPoint> getPolicyInformationPoints() {
        return this.pips;
    }

    public ObligationService getObligationService() {
        return this.obligationService;
    }

    protected final synchronized void setAuthzDecisionQuerySecurityPolicy(SecurityPolicy policy) {
        if (this.authzDecisionQuerySecurityPolicy != null) {
            throw new IllegalStateException("Authorization decision security policy has already been set, it may not be changed");
        }
        this.authzDecisionQuerySecurityPolicy = policy;
    }

    protected final synchronized void setPAPEndpoints(List<String> paps) {
        if (this.papEndpoints != null) {
            throw new IllegalStateException("Policy administration points have already been set, it may not changed");
        }
        this.papEndpoints = paps != null ? Collections.unmodifiableList(paps) : Collections.emptyList();
    }

    protected final synchronized void setPolicyRetentionInterval(int interval) {
        if (this.policyRetentionInterval != 0) {
            throw new IllegalStateException("Policy refresh interval has already been set, it may not be changed");
        }
        this.policyRetentionInterval = interval;
    }

    protected final synchronized void setPolicySetId(String id) {
        if (this.policySetId != null) {
            throw new IllegalStateException("Policy set ID has already been set, it may not changed");
        }
        this.policySetId = id;
    }

    protected final synchronized void setPolicyInformationPoints(List<PolicyInformationPoint> policyInformationPoints) {
        if (policyInformationPoints == null || policyInformationPoints.isEmpty()) {
            return;
        }
        if (this.pips != null) {
            throw new IllegalArgumentException("Policy Information Points have already been set, they may not be changed");
        }
        this.pips = Collections.unmodifiableList(policyInformationPoints);
    }

    protected final synchronized void setObligationService(ObligationService service) {
        if (service == null) {
            return;
        }
        if (this.obligationService != null) {
            throw new IllegalArgumentException("Obligation service has already been set, they may not be changed");
        }
        this.obligationService = service;
    }
}

