/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.utils.https.impl.canl;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationError;
import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.FormatMode;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CANLListener
implements StoreUpdateListener,
ValidationErrorListener {
    public static final Logger logger = LoggerFactory.getLogger(CANLListener.class);

    public void loadingNotification(String location, String type, StoreUpdateListener.Severity level, Exception cause) {
        if (location.startsWith("file:")) {
            location = location.substring(5, location.length());
        }
        if (level.equals((Object)StoreUpdateListener.Severity.ERROR)) {
            logger.error("Error for {} {}: {}.", new Object[]{type, location, cause.getMessage()});
        } else if (level.equals((Object)StoreUpdateListener.Severity.WARNING)) {
            logger.debug("Warning for {} {}: {}.", new Object[]{type, location, cause.getMessage()});
        } else if (level.equals((Object)StoreUpdateListener.Severity.NOTIFICATION)) {
            logger.debug("Loading {} {}.", new Object[]{type, location});
        }
    }

    public boolean onValidationError(ValidationError error) {
        String certChainInfo = CertificateUtils.format((X509Certificate[])error.getChain(), (FormatMode)FormatMode.COMPACT_ONE_LINE);
        logger.warn("Certificate validation error for chain: {}", (Object)certChainInfo);
        logger.warn("Validation Error: {}", (Object)error.getMessage());
        return false;
    }
}

