/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.utils.https;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.italiangrid.utils.collections.Strings;

public class PasswordProtectFilter
implements Filter {
    public static final String PASSWORD_PARAM_NAME = "password";
    private final String requestPassword;

    public PasswordProtectFilter(String password) {
        this.requestPassword = Strings.safeTrimOrNullString(password);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String password = Strings.safeTrimOrNullString(request.getParameter(PASSWORD_PARAM_NAME));
        if (this.requestPassword != null && !this.requestPassword.equals(password)) {
            ((HttpServletResponse)response).setStatus(401);
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

