/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.policymanagement;

import java.rmi.RemoteException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.ui.cli.CLIException;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.policymanagement.PolicyManagementCLI;

public class RemovePolicies
extends PolicyManagementCLI {
    private static final String[] commandNameValues = new String[]{"remove-policy", "rp"};
    private static final String DESCRIPTION = "Remove policies (resources, actions or rules) by id.";
    private static final String USAGE = "[options] id...";
    private String alias = null;

    public RemovePolicies() {
        super(commandNameValues, USAGE, DESCRIPTION, null);
    }

    protected Options defineCommandOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_PAPALIAS_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_PAPALIAS_LONG);
        options.addOption(OptionBuilder.create());
        return options;
    }

    protected int executeCommand(CommandLine commandLine) throws CLIException, ParseException, RemoteException {
        String[] args = commandLine.getArgs();
        if (args.length < 2) {
            throw new ParseException("Wrong number of arguments: specify one or more ids.");
        }
        if (commandLine.hasOption(OPT_PAPALIAS_LONG)) {
            this.alias = commandLine.getOptionValue(OPT_PAPALIAS_LONG);
        }
        boolean partialSuccess = false;
        boolean failure = false;
        try {
            for (int i = 1; i < args.length; ++i) {
                boolean policyRemoved;
                String policyId = args[i];
                if (this.verboseMode) {
                    System.out.print("Removing \"" + policyId + "\"... ");
                }
                if (!(policyRemoved = this.xacmlPolicyMgmtClient.removeObjectByIdAndReferences(this.alias, policyId))) {
                    if (this.verboseMode) {
                        System.out.println("error: not found.");
                    } else {
                        System.out.println("Error id not found: " + policyId);
                    }
                    failure = true;
                    continue;
                }
                partialSuccess = true;
                if (!this.verboseMode) continue;
                System.out.println("ok.");
            }
        }
        catch (RemoteException e) {
            System.out.println("error.");
            throw e;
        }
        if (failure && !partialSuccess) {
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        if (failure && partialSuccess) {
            return ServiceCLI.ExitStatus.PARTIAL_SUCCESS.ordinal();
        }
        return ServiceCLI.ExitStatus.SUCCESS.ordinal();
    }
}

