/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.policymanagement;

import java.rmi.RemoteException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.policymanagement.PolicyManagementCLI;

public class RemoveAllPolicies
extends PolicyManagementCLI {
    private static final String[] commandNameValues = new String[]{"remove-all-policies", "rap"};
    private static final String DESCRIPTION = "Delete all policies of a pap. Use option --" + OPT_PAPALIAS_LONG + " to specify a pap different " + "than the default one.";
    private static final String USAGE = "[options]";
    private String alias = null;

    public RemoveAllPolicies() {
        super(commandNameValues, USAGE, DESCRIPTION, null);
    }

    protected Options defineCommandOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_PAPALIAS_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_PAPALIAS_LONG);
        options.addOption(OptionBuilder.create());
        return options;
    }

    protected int executeCommand(CommandLine commandLine) throws ParseException, RemoteException {
        if (commandLine.getArgs().length != 1) {
            throw new ParseException("Wrong number of arguments");
        }
        if (commandLine.hasOption(OPT_PAPALIAS_LONG)) {
            this.alias = commandLine.getOptionValue(OPT_PAPALIAS_LONG);
        }
        if (this.verboseMode) {
            System.out.print("Removing all policies... ");
        }
        this.highlevelPolicyMgmtClient.eraseRepository(this.alias);
        if (this.verboseMode) {
            System.out.println("ok");
        }
        return ServiceCLI.ExitStatus.SUCCESS.ordinal();
    }
}

