/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.policymanagement;

import java.rmi.RemoteException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.policymanagement.PolicyManagementCLI;

public class BanAttribute
extends PolicyManagementCLI {
    private static String[] COMMAND_NAME_VALUES = new String[]{"ban"};
    private static String DESCRIPTION = "Ban an attribute. <id> is any of the attribute ids that can be specified in the simplified policy language. By default the attribute is banned for resource and action both with value \".*\". Different values for resource and action can be set using options --" + OPT_RESOURCE_LONG + " and --" + OPT_ACTION_LONG + ".\nExample:\n pap-admin ban subject \"/C=IT/O=INFN/OU=Personal Certificate/L=CNAF/CN=Alberto Forti\"\n" + "pap-admin ban fqan /dteam/test";
    private static String USAGE = "[options] <id> <value>";
    private String alias = null;

    public BanAttribute() {
        super(COMMAND_NAME_VALUES, USAGE, DESCRIPTION, null);
    }

    protected Options defineCommandOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Set the policy as public (default)");
        OptionBuilder.withLongOpt((String)"public");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Set the policy as private (it won't be distributed)");
        OptionBuilder.withLongOpt((String)"private");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_ACTION_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_ACTION_LONG);
        options.addOption(OptionBuilder.create((String)OPT_ACTION));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_RESOURCE_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_RESOURCE_LONG);
        options.addOption(OptionBuilder.create((String)OPT_RESOURCE));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_PAPALIAS_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_PAPALIAS_LONG);
        options.addOption(OptionBuilder.create());
        return options;
    }

    protected int executeCommand(CommandLine commandLine) throws ParseException, RemoteException {
        String[] args = commandLine.getArgs();
        if (args.length != 3) {
            throw new ParseException("Wrong number of arguments");
        }
        String id = args[1];
        String value = args[2];
        if (commandLine.hasOption(OPT_PAPALIAS_LONG)) {
            this.alias = commandLine.getOptionValue(OPT_PAPALIAS_LONG);
        }
        boolean isPublic = true;
        if (commandLine.hasOption("private")) {
            isPublic = false;
        }
        String resource = null;
        String action = null;
        resource = commandLine.hasOption(OPT_RESOURCE) ? commandLine.getOptionValue(OPT_RESOURCE) : ".*";
        action = commandLine.hasOption(OPT_ACTION) ? commandLine.getOptionValue(OPT_ACTION) : ".*";
        if (this.verboseMode) {
            System.out.print("Adding deny rule... ");
        }
        String policyId = null;
        policyId = this.highlevelPolicyMgmtClient.ban(this.alias, id, value, resource, action, isPublic);
        if (policyId == null) {
            this.printOutputMessage(String.format("error (ban rule already exists).", new Object[0]));
        } else if (this.verboseMode) {
            System.out.println("ok");
        }
        return ServiceCLI.ExitStatus.SUCCESS.ordinal();
    }
}

