/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.policymanagement;

import java.rmi.RemoteException;
import java.util.LinkedList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizard;
import org.glite.authz.pap.common.xacml.wizard.exceptions.UnsupportedAttributeException;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.policymanagement.PolicyManagementCLI;
import org.glite.authz.pap.ui.cli.policymanagement.XACMLPolicyCLIUtils;

public class AddPolicy
extends PolicyManagementCLI {
    private static String OPT_ACTIONID_LONG = "action-id";
    private static String OPT_ACTIONID_DESCRIPTION = "Specify an action-id.";
    private static String OPT_AFTER_RULEID_LONG = "after-rule-id";
    private static String OPT_AFTER_RULEID_DESCRIPTION = "Insert after the given rule-id (needs option --" + OPT_ACTIONID_LONG + ").";
    private static String OPT_BEFORE_RULEID_LONG = "before-rule-id";
    private static String OPT_BEFORE_RULEID_DESCRIPTION = "Insert before the given rule-id (needs option --" + OPT_ACTIONID_LONG + ").";
    private static final String OPT_OBLIGATION_LONG = "obligation";
    private static final String OPT_OBLIGATION_DESCRIPTION = "Specify an obligation.";
    private static final String OPT_OBLIGATION_SCOPE_LONG = "obligation-scope";
    private static final String OPT_OBLIGATION_SCOPE_DESCRIPTION = "Define in which scope the obligation will be defined. Possible values: 'action','resource'.";
    private static final String OPT_BOTTOM_LONG = "bottom";
    private static final String OPT_BOTTOM_DESCRIPTION = "Add the policy at the end of the list of rules of the given action.";
    private static final String[] COMMAND_NAME_VALUES = new String[]{"add-policy", "ap"};
    private static final String DESCRIPTION = "Add a permit/deny policy.\nParameters:\n<permit|deny>  \"permit\" or \"deny\" to add a, respectively, permit/deny policy.\n<id=value>     a string in the form \"<id>=<value>\", where <id> is any of the attribute ids that can be specified in the simplified policy language and <value> the value to be assigned (e.g. fqan=/vo/group).";
    private static final String LONG_DESCRIPTION = "This command allows to add a rule into an action by specifying an action-id of an existing action (option --" + OPT_ACTIONID_LONG + ") or a resource/action value (options --" + OPT_RESOURCE_LONG + " and --" + OPT_ACTION_LONG + "). In the latter case a new resource and/or action are created if they don't already exist. " + "\nBy default the rule is inserted at the top of an action. To change this behaviour use one of the following options: --" + "bottom" + ", --" + OPT_AFTER_RULEID_LONG + ", --" + OPT_BEFORE_RULEID_LONG + ".";
    private static final String USAGE = "[options] <permit|deny> <id=value>...";
    private String alias = null;

    public AddPolicy() {
        super(COMMAND_NAME_VALUES, USAGE, DESCRIPTION, LONG_DESCRIPTION);
    }

    protected Options defineCommandOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_AFTER_RULEID_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_AFTER_RULEID_LONG);
        OptionBuilder.withArgName((String)"rule-id");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_BEFORE_RULEID_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_BEFORE_RULEID_LONG);
        OptionBuilder.withArgName((String)"rule-id");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)OPT_BOTTOM_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_BOTTOM_LONG);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_PAPALIAS_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_PAPALIAS_LONG);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_ACTIONID_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_ACTIONID_LONG);
        OptionBuilder.withArgName((String)"action-id");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_ACTION_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_ACTION_LONG);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_RESOURCE_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_RESOURCE_LONG);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_OBLIGATION_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_OBLIGATION_LONG);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_OBLIGATION_SCOPE_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_OBLIGATION_SCOPE_LONG);
        options.addOption(OptionBuilder.create());
        return options;
    }

    protected int executeCommand(CommandLine commandLine) throws ParseException, RemoteException {
        boolean isPermit;
        String[] args = commandLine.getArgs();
        if (args.length < 3) {
            throw new ParseException("Wrong number of arguments. Usage: [options] <permit|deny> <id=value>...");
        }
        if ("permit".equals(args[1].toLowerCase())) {
            isPermit = true;
        } else if ("deny".equals(args[1].toLowerCase())) {
            isPermit = false;
        } else {
            throw new ParseException("First argument must be \"permit\" or \"deny\" (found: " + args[1] + ")");
        }
        XACMLPolicyCLIUtils.initAttributeWizard();
        LinkedList<String> attributeList = new LinkedList<String>();
        for (int i = 2; i < args.length; ++i) {
            try {
                new AttributeWizard(args[i]);
                attributeList.add(args[i]);
                continue;
            }
            catch (UnsupportedAttributeException e) {
                break;
            }
        }
        if (attributeList.size() == 0) {
            throw new ParseException("Wrong number of arguments. Specify at least one attribute <id=value>");
        }
        String actionId = null;
        String ruleId = null;
        String actionValue = null;
        String resourceValue = null;
        boolean afterRule = false;
        if (commandLine.hasOption(OPT_ACTIONID_LONG)) {
            actionId = commandLine.getOptionValue(OPT_ACTIONID_LONG);
        }
        if (commandLine.hasOption(OPT_AFTER_RULEID_LONG)) {
            ruleId = commandLine.getOptionValue(OPT_AFTER_RULEID_LONG);
            afterRule = true;
        }
        if (commandLine.hasOption(OPT_BEFORE_RULEID_LONG)) {
            ruleId = commandLine.getOptionValue(OPT_BEFORE_RULEID_LONG);
            afterRule = false;
        }
        if (commandLine.hasOption(OPT_ACTION_LONG)) {
            actionValue = commandLine.getOptionValue(OPT_ACTION_LONG);
        }
        if (commandLine.hasOption(OPT_RESOURCE_LONG)) {
            resourceValue = commandLine.getOptionValue(OPT_RESOURCE_LONG);
        }
        if (actionId == null) {
            if (resourceValue == null && actionValue == null && ruleId != null) {
                throw new ParseException(String.format("Options --%s and --%s need option --%s.", OPT_BEFORE_RULEID_LONG, OPT_AFTER_RULEID_LONG, OPT_ACTIONID_LONG));
            }
            if (resourceValue == null && actionValue == null) {
                throw new ParseException(String.format("Specify an action-id or a resource/action value.", new Object[0]));
            }
            if (resourceValue == null || actionValue == null) {
                throw new ParseException(String.format("--%s and --%s must be both present.", OPT_RESOURCE_LONG, OPT_ACTION_LONG));
            }
            if (ruleId != null) {
                throw new ParseException(String.format("Options --%s and --%s need option --%s and cannot be used with options --%s and --%s.", OPT_BEFORE_RULEID_LONG, OPT_AFTER_RULEID_LONG, OPT_ACTIONID_LONG, OPT_RESOURCE_LONG, OPT_ACTION_LONG));
            }
        } else if (actionValue != null || resourceValue != null) {
            throw new ParseException(String.format("Option --%s cannot be used with options --%s and --%s.", OPT_ACTIONID_LONG, OPT_RESOURCE_LONG, OPT_ACTION_LONG));
        }
        if (commandLine.hasOption(OPT_PAPALIAS_LONG)) {
            this.alias = commandLine.getOptionValue(OPT_PAPALIAS_LONG);
        }
        boolean bottom = false;
        if (commandLine.hasOption(OPT_BOTTOM_LONG)) {
            bottom = true;
        }
        if (bottom && ruleId != null) {
            throw new ParseException("Specify one of --bottom option or \"rule-id\", not both at the same time.");
        }
        if (bottom) {
            afterRule = true;
        }
        String obligationId = null;
        String obligationScope = "resource";
        if (commandLine.hasOption(OPT_OBLIGATION_LONG)) {
            obligationId = commandLine.getOptionValue(OPT_OBLIGATION_LONG);
            if (commandLine.hasOption(OPT_OBLIGATION_SCOPE_LONG)) {
                String osParsedValue = commandLine.getOptionValue(OPT_OBLIGATION_SCOPE_LONG);
                if (osParsedValue.trim().equals("action") || osParsedValue.trim().equals("resource")) {
                    obligationScope = osParsedValue.trim();
                } else {
                    throw new ParseException("Unrecognized value for the --obligation-scope option: '" + osParsedValue + "'. Possible values are 'action' and 'resource'.");
                }
            }
        }
        if (this.verboseMode) {
            System.out.print("Adding policy... ");
        }
        String policyId = null;
        policyId = this.highlevelPolicyMgmtClient.addRule(this.alias, isPermit, attributeList.toArray(new String[attributeList.size()]), actionValue, resourceValue, actionId, ruleId, obligationId, obligationScope, afterRule);
        if (policyId == null) {
            this.printOutputMessage(String.format("error.", new Object[0]));
        } else if (this.verboseMode) {
            System.out.println("ok");
        }
        return ServiceCLI.ExitStatus.SUCCESS.ordinal();
    }
}

