/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.policymanagement;

import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.utils.PolicySetHelper;
import org.glite.authz.pap.common.xacml.wizard.PolicySetWizard;
import org.glite.authz.pap.common.xacml.wizard.PolicyWizard;
import org.glite.authz.pap.common.xacml.wizard.XACMLWizard;
import org.glite.authz.pap.encoder.EncodingException;
import org.glite.authz.pap.encoder.PolicyFileEncoder;
import org.glite.authz.pap.ui.cli.CLIException;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.policymanagement.PolicyManagementCLI;
import org.glite.authz.pap.ui.cli.policymanagement.XACMLPolicyCLIUtils;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddPoliciesFromFile
extends PolicyManagementCLI {
    private static final Logger log = LoggerFactory.getLogger(AddPoliciesFromFile.class);
    private static final String[] commandNameValues = new String[]{"add-policies-from-file", "apf"};
    private static final String DESCRIPTION = "Add policies defined in the given file.\nParameters:\n<file>       policy file defining a set of resource elements or a set of action elements.\n[resourceId] resource id where insert actions into.\n";
    private static final String LONG_DESCRIPTION = "If <file> defines a set of resource elements \"resourceId\" must not be provided, otherwise if only action elements are defined \"resourceId\" indentifies the resource element in which inserting the given action elements into. By default elements are inserted at the bottom. To change this behaviour two options can be used: \"--" + OPT_BEFORE_ID_LONG + " <id>\" to insert before the given <id>, and \"--" + OPT_AFTER_ID_LONG + " <id>\" to insert after the given <id>.";
    private static final String USAGE = "[options] <file> [resourceId]";
    private PolicyFileEncoder policyFileEncoder = new PolicyFileEncoder();
    private List<XACMLWizard> xacmlWizardList;
    private String resourceId = null;
    private String pivotId = null;
    private String alias = null;
    private boolean moveAfter = false;

    public AddPoliciesFromFile() {
        super(commandNameValues, USAGE, DESCRIPTION, LONG_DESCRIPTION);
    }

    private boolean addResources() throws RemoteException {
        for (XACMLWizard xacmlWizard : this.xacmlWizardList) {
            if (xacmlWizard instanceof PolicySetWizard) continue;
            System.out.println(String.format("Error: found action element (%s). Only highlevel \"resource\" elements are allowed.", ((PolicyWizard)xacmlWizard).getTagAndValue()));
            return false;
        }
        if (this.resourceId != null) {
            System.out.println("Error cannot use \"resourceId\" to insert resource elements.");
            return false;
        }
        int position = -1;
        if (this.pivotId != null) {
            PolicySetType rootPolicySet = this.xacmlPolicyMgmtClient.getRootPolicySet(null);
            position = PolicySetHelper.getPolicySetIdReferenceIndex(rootPolicySet, this.pivotId);
            if (position == -1) {
                System.out.println("id \"" + this.pivotId + "\" not found (or it's not a resource id).");
                return false;
            }
            if (this.moveAfter) {
                ++position;
            }
        }
        boolean result = true;
        for (XACMLWizard xacmlWizard : this.xacmlWizardList) {
            PolicySetWizard policySetWizard = (PolicySetWizard)xacmlWizard;
            PolicySetType policySet = policySetWizard.getXACML();
            policySet.getPolicyIdReferences().clear();
            policySetWizard.releaseDOM();
            String policySetId = this.xacmlPolicyMgmtClient.addPolicySet(this.alias, position, policySet);
            if (position != -1) {
                ++position;
            }
            if (policySetId == null) {
                System.out.println(String.format("Error policy set not added: %s (id=%s). Skipping all the policies defined inside.", policySetWizard.getTagAndValue(), policySetWizard.getPolicySetId()));
                result = false;
                continue;
            }
            if (this.verboseMode) {
                System.out.println(String.format("Added policy set: %s (id=%s)", policySetWizard.getTagAndValue(), policySetId));
            }
            int size = policySetWizard.getPolicyWizardList().size();
            PolicyType[] policyArray = new PolicyType[size];
            String[] idPrefixArray = new String[size];
            String[] tagAndValueArray = new String[size];
            for (int i = 0; i < size; ++i) {
                PolicyWizard policyWizard = policySetWizard.getPolicyWizardList().get(i);
                policyArray[i] = policyWizard.getXACML();
                TypeStringUtils.releaseUnneededMemory(policyArray[i]);
                idPrefixArray[i] = policyWizard.getPolicyIdPrefix();
                tagAndValueArray[i] = policyWizard.getTagAndValue();
                TypeStringUtils.releaseUnneededMemory(policyWizard);
            }
            String[] policyIdArray = this.xacmlPolicyMgmtClient.addPolicies(this.alias, 0, policySetId, idPrefixArray, policyArray);
            for (int i = 0; i < size; ++i) {
                String policyId = policyIdArray[i];
                String tagAndValue = tagAndValueArray[i];
                if (policyId == null) {
                    System.out.println(String.format("Error policy not added: %s", tagAndValue));
                    result = false;
                    continue;
                }
                if (!this.verboseMode) continue;
                System.out.println(String.format("Added policy: %s (id=%s)", tagAndValue, policyId));
            }
            if (!this.verboseMode) continue;
            System.out.println();
        }
        return result;
    }

    private boolean addActions() throws RemoteException {
        ArrayList<PolicyWizard> policyWizardList = new ArrayList<PolicyWizard>(this.xacmlWizardList.size());
        for (XACMLWizard xacmlWizard : this.xacmlWizardList) {
            if (!(xacmlWizard instanceof PolicyWizard)) {
                System.out.println(String.format("Error: found resource element (%s). Only \"action\" highlevel elements are allowed.", ((PolicySetWizard)xacmlWizard).getTagAndValue()));
                return false;
            }
            policyWizardList.add((PolicyWizard)xacmlWizard);
        }
        if (this.resourceId == null) {
            System.out.println("Error \"resourceId\" is needed to insert action elements");
            return false;
        }
        PolicySetType targetPolicySet = this.xacmlPolicyMgmtClient.getPolicySet(this.alias, this.resourceId);
        int position = -1;
        if (this.pivotId != null) {
            position = PolicySetHelper.getPolicyIdReferenceIndex(targetPolicySet, this.pivotId);
            TypeStringUtils.releaseUnneededMemory(targetPolicySet);
            if (position == -1) {
                System.out.println("id \"" + this.pivotId + "\" not found inside resource the given resource (id = \"" + this.resourceId + "\").");
                return false;
            }
            if (this.moveAfter) {
                ++position;
            }
        }
        boolean result = true;
        int size = this.xacmlWizardList.size();
        PolicyType[] policyArray = new PolicyType[size];
        String[] idPrefixArray = new String[size];
        String[] tagAndValueArray = new String[size];
        for (int i = 0; i < size; ++i) {
            PolicyWizard policyWizard = (PolicyWizard)policyWizardList.get(i);
            policyArray[i] = policyWizard.getXACML();
            TypeStringUtils.releaseUnneededMemory(policyArray[i]);
            idPrefixArray[i] = policyWizard.getPolicyIdPrefix();
            tagAndValueArray[i] = policyWizard.getTagAndValue();
            TypeStringUtils.releaseUnneededMemory(policyWizard);
            policyWizard = null;
        }
        log.debug("Inserting actions into position: " + position);
        String[] policyIdArray = this.xacmlPolicyMgmtClient.addPolicies(this.alias, position, this.resourceId, idPrefixArray, policyArray);
        for (int i = 0; i < size; ++i) {
            String policyId = policyIdArray[i];
            String tagAndValue = tagAndValueArray[i];
            if (policyId == null) {
                System.out.println(String.format("Error policy not added: %s", tagAndValue));
                result = false;
                continue;
            }
            if (!this.verboseMode) continue;
            System.out.println(String.format("Added policy: %s (id=%s)", tagAndValue, policyId));
        }
        if (this.verboseMode) {
            System.out.println();
        }
        return result;
    }

    protected Options defineCommandOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_AFTER_ID_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_AFTER_ID_LONG);
        OptionBuilder.withArgName((String)"id");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_BEFORE_ID_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_BEFORE_ID_LONG);
        OptionBuilder.withArgName((String)"id");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)OPT_PAPALIAS_DESCRIPTION);
        OptionBuilder.withLongOpt((String)OPT_PAPALIAS_LONG);
        OptionBuilder.withArgName((String)"alias");
        options.addOption(OptionBuilder.create());
        return options;
    }

    protected int executeCommand(CommandLine commandLine) throws CLIException, ParseException, RemoteException {
        String[] args = commandLine.getArgs();
        if (args.length < 2 || args.length > 3) {
            throw new ParseException("Wrong number of arguments.");
        }
        if (commandLine.hasOption(OPT_PAPALIAS_LONG)) {
            this.alias = commandLine.getOptionValue(OPT_PAPALIAS_LONG);
        }
        if (args.length == 3) {
            this.resourceId = args[2];
        }
        if (commandLine.hasOption(OPT_BEFORE_ID_LONG)) {
            this.pivotId = commandLine.getOptionValue(OPT_BEFORE_ID_LONG);
            this.moveAfter = false;
        }
        if (commandLine.hasOption(OPT_AFTER_ID_LONG)) {
            this.pivotId = commandLine.getOptionValue(OPT_AFTER_ID_LONG);
            this.moveAfter = true;
        }
        log.trace("args.lengh=" + args.length);
        log.trace("resourceId=" + this.resourceId);
        log.trace("pivotId=" + this.pivotId);
        log.trace("moveAfter=" + this.moveAfter);
        File file = new File(args[1]);
        XACMLPolicyCLIUtils.initOpenSAMLAndAttributeWizard();
        try {
            this.xacmlWizardList = this.policyFileEncoder.parse(file);
        }
        catch (EncodingException e) {
            System.out.println("Syntax error no policies has been added from file:" + file.getAbsolutePath());
            System.out.println("Reason:");
            System.out.println(e.getMessage());
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        if (this.xacmlWizardList.isEmpty()) {
            System.out.println("No policies defined in the given file");
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        boolean result = this.xacmlWizardList.get(0) instanceof PolicySetWizard ? this.addResources() : this.addActions();
        if (result) {
            if (this.verboseMode) {
                System.out.println("Success: policies has been added from file " + file.getAbsolutePath());
            }
        } else {
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        return ServiceCLI.ExitStatus.SUCCESS.ordinal();
    }
}

