/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.papmanagement;

import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.papmanagement.PAPManagementCLI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshCache
extends PAPManagementCLI {
    private static final String[] commandNameValues = new String[]{"refresh-cache", "rc"};
    private static final String DESCRIPTION = "Invalidates the local policy cache and retrieves policies from remote paps. The arguments identify the paps that will be contacted. If no arguments are given, all the remote paps are contacted.";
    private static final String USAGE = "[alias]...]";

    public RefreshCache() {
        super(commandNameValues, USAGE, DESCRIPTION, null);
    }

    private List<String> getAllAliases() throws RemoteException {
        Pap[] papArray;
        LinkedList<String> aliasList = new LinkedList<String>();
        for (Pap pap : papArray = this.papMgmtClient.getAllPaps()) {
            if (!pap.isRemote()) continue;
            aliasList.add(pap.getAlias());
        }
        return aliasList;
    }

    @Override
    protected Options defineCommandOptions() {
        return null;
    }

    @Override
    protected int executeCommand(CommandLine commandLine) throws RemoteException {
        List<String> aliasList;
        String[] args = commandLine.getArgs();
        if (args.length == 1) {
            aliasList = this.getAllAliases();
        } else {
            aliasList = new LinkedList<String>();
            for (int i = 1; i < args.length; ++i) {
                aliasList.add(args[i]);
            }
        }
        if (aliasList.isEmpty()) {
            System.out.println("No remote PAPs found.");
            return ServiceCLI.ExitStatus.SUCCESS.ordinal();
        }
        boolean success = false;
        boolean failure = false;
        for (String alias : aliasList) {
            System.out.print("Refreshing cache for pap \"" + alias + "\"...");
            try {
                boolean papExists = this.papMgmtClient.refreshCache(alias);
                if (papExists) {
                    System.out.println(" ok.");
                    success = true;
                    continue;
                }
                System.out.println(" error: pap doesn't exist");
                failure = true;
            }
            catch (RemoteException e) {
                System.out.println("error: " + e.getMessage());
                failure = true;
            }
        }
        if (success && failure) {
            return ServiceCLI.ExitStatus.PARTIAL_SUCCESS.ordinal();
        }
        if (!success && failure) {
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        return ServiceCLI.ExitStatus.SUCCESS.ordinal();
    }
}

