/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli.papmanagement;

import java.rmi.RemoteException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.papmanagement.PAPManagementCLI;

public class DisablePap
extends PAPManagementCLI {
    private static final String[] commandNameValues = new String[]{"disable-pap", "dpap"};
    private static final String DESCRIPTION = "Set a pap as disabled (i.e. PDPs won't get its policies).";
    private static final String USAGE = "<alias>";

    public DisablePap() {
        super(commandNameValues, USAGE, DESCRIPTION, null);
    }

    protected Options defineCommandOptions() {
        return null;
    }

    protected int executeCommand(CommandLine commandLine) throws ParseException, RemoteException {
        String[] args = commandLine.getArgs();
        if (args.length != 2) {
            throw new ParseException("Wrong number of arguments");
        }
        String alias = args[1];
        if (!this.papMgmtClient.exists(alias)) {
            System.out.println("PAP not found: " + alias);
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        this.papMgmtClient.setEnabled(alias, false);
        return ServiceCLI.ExitStatus.SUCCESS.ordinal();
    }
}

