/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli;

import eu.emi.security.authn.x509.impl.PEMCredential;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.bouncycastle.openssl.PasswordFinder;
import org.glite.authz.pap.client.ServiceClient;
import org.glite.authz.pap.client.ServiceClientFactory;
import org.glite.authz.pap.common.exceptions.PAPException;
import org.glite.authz.pap.common.utils.Utils;
import org.glite.authz.pap.ui.cli.CLIException;
import org.glite.authz.pap.ui.cli.ConsolePasswordFinder;
import org.glite.authz.pap.ui.cli.HelpMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceCLI {
    private static final Logger log = LoggerFactory.getLogger(ServiceCLI.class);
    private static final HelpFormatter helpFormatter = new HelpFormatter();
    private static final String OPT_PROXY_DESCRIPTION = "Specifies a user proxy to be used for authentication.";
    private static final String OPT_PROXY_LONG = "proxy";
    private static final String OPT_CERT_DESCRIPTION = "Specifies non-standard user certificate.";
    private static final String OPT_CERT_LONG = "cert";
    private static final String OPT_HOST_DESCRIPTION = "Specifies the target PAP hostname (default is localhost). This option defines the PAP endpoint to be contacted as follows: https://arg:port/pap/services/";
    private static final String OPT_HOST_LONG = "host";
    private static final String OPT_KEY_DESCRIPTION = "Specifies non-standard user private key.";
    private static final String OPT_KEY_LONG = "key";
    private static final String OPT_PORT = "p";
    private static final String OPT_PORT_DESCRIPTION = "Specifies the port on which the target PAP is listening (default is 8150)";
    private static final String OPT_PORT_LONG = "port";
    private static final String OPT_URL_LONG = "url";
    private static final String OPT_VERBOSE = "v";
    private static final String OPT_VERBOSE_DESCRIPTION = "Verbose mode.";
    private static final String OPT_VERBOSE_LONG = "verbose";
    protected static final String DEFAULT_SERVICE_URL = "https://%s:%s%s";
    protected static final String OPT_HELP = "h";
    protected static final String OPT_HELP_DESCRIPTION = "Print this message.";
    protected static final String OPT_HELP_LONG = "help";
    protected static final String OPT_PRIVATE_LONG = "private";
    protected static final String OPT_PUBLIC_LONG = "public";
    protected static final String PAP_HOST_PROPERTY = "host";
    protected static final String PAP_PORT_PROPERTY = "port";
    protected static final CommandLineParser parser = new GnuParser();
    private String[] commandNameValues;
    private Options commandOptions;
    private String descriptionText;
    private static Options globalOptions = ServiceCLI.defineGlobalOptions();
    private String longDescriptionText;
    private Options options;
    private final ServiceClient serviceClient;
    private String usageText;
    protected boolean verboseMode = false;

    public ServiceCLI(String[] commandNameValues, String usage, String description, String longDescription) {
        ServiceClientFactory serviceClientFactory = ServiceClientFactory.getServiceClientFactory();
        this.serviceClient = serviceClientFactory.createServiceClient();
        helpFormatter.setWidth(80);
        helpFormatter.setLeftPadding(4);
        this.commandNameValues = commandNameValues;
        this.usageText = usage;
        this.descriptionText = description;
        this.longDescriptionText = longDescription;
        this.commandOptions = this.defineCommandOptions();
        if (this.commandOptions == null) {
            this.commandOptions = new Options();
        }
        this.commandOptions.addOption(OPT_HELP, OPT_HELP_LONG, false, OPT_HELP_DESCRIPTION);
        this.options = new Options();
        Collection optionsList = this.commandOptions.getOptions();
        for (Option opt : optionsList) {
            this.options.addOption(opt);
        }
        optionsList = globalOptions.getOptions();
        for (Option opt : optionsList) {
            this.options.addOption(opt);
        }
    }

    public static Options getGlobalOptions() {
        return globalOptions;
    }

    private static Options defineGlobalOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withLongOpt((String)OPT_URL_LONG);
        OptionBuilder.withDescription((String)("Specifies the target PAP endpoint (default: " + String.format(DEFAULT_SERVICE_URL, "localhost", "8150", "/pap/services/") + ")."));
        OptionBuilder.withArgName((String)OPT_URL_LONG);
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withLongOpt((String)"host");
        OptionBuilder.withDescription((String)OPT_HOST_DESCRIPTION);
        OptionBuilder.withArgName((String)"hostname");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.withDescription((String)OPT_PORT_DESCRIPTION);
        options.addOption(OptionBuilder.create((String)OPT_PORT));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withLongOpt((String)OPT_PROXY_LONG);
        OptionBuilder.withDescription((String)OPT_PROXY_DESCRIPTION);
        OptionBuilder.withArgName((String)"file");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withLongOpt((String)OPT_CERT_LONG);
        OptionBuilder.withDescription((String)OPT_CERT_DESCRIPTION);
        OptionBuilder.withArgName((String)"file");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withLongOpt((String)OPT_KEY_LONG);
        OptionBuilder.withDescription((String)OPT_KEY_DESCRIPTION);
        OptionBuilder.withArgName((String)"file");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withLongOpt((String)OPT_VERBOSE_LONG);
        OptionBuilder.withDescription((String)OPT_VERBOSE_DESCRIPTION);
        options.addOption(OptionBuilder.create((String)OPT_VERBOSE));
        return options;
    }

    public boolean commandMatch(String command) {
        for (String value : this.commandNameValues) {
            if (!value.equals(command)) continue;
            return true;
        }
        return false;
    }

    public int execute(String[] args) throws ParseException, HelpMessageException, RemoteException {
        String keyPassword;
        CommandLine commandLine = parser.parse(this.options, args);
        if (commandLine.hasOption(OPT_HELP)) {
            throw new HelpMessageException();
        }
        if (commandLine.hasOption(OPT_VERBOSE)) {
            this.verboseMode = true;
        }
        if (commandLine.hasOption(OPT_URL_LONG)) {
            this.serviceClient.setTargetEndpoint(commandLine.getOptionValue(OPT_URL_LONG));
        } else {
            String host = "localhost";
            String papHostProperty = System.getProperty("host");
            if (papHostProperty != null && !"".equals(papHostProperty.trim())) {
                host = papHostProperty;
            }
            String port = "8150";
            String papPortProperty = System.getProperty("port");
            if (papPortProperty != null && !"".equals(papPortProperty.trim())) {
                port = papPortProperty;
            }
            if (commandLine.hasOption("host")) {
                host = commandLine.getOptionValue("host");
            }
            if (commandLine.hasOption(OPT_PORT)) {
                port = commandLine.getOptionValue(OPT_PORT);
            }
            try {
                Integer.valueOf(port);
            }
            catch (NumberFormatException e) {
                throw new ParseException(String.format("Invalid port number \"%s\" (option -%s, --%s)", port, OPT_PORT, "port"));
            }
            this.serviceClient.setTargetEndpoint(String.format(DEFAULT_SERVICE_URL, host, port, "/pap/services/"));
        }
        boolean credentialsNotRetrieved = true;
        if (commandLine.hasOption(OPT_PROXY_LONG)) {
            this.serviceClient.setClientProxy(commandLine.getOptionValue(OPT_PROXY_LONG));
            credentialsNotRetrieved = false;
        }
        if (commandLine.hasOption(OPT_CERT_LONG)) {
            if (commandLine.hasOption(OPT_PROXY_LONG)) {
                throw new ParseException(String.format("Conflicting options --%s and --%s.", OPT_PROXY_LONG, OPT_CERT_LONG));
            }
            if (!commandLine.hasOption(OPT_KEY_LONG)) {
                throw new ParseException(String.format("Option --%s requires also option --%s.", OPT_CERT_LONG, OPT_KEY_LONG));
            }
            this.serviceClient.setClientCertificate(commandLine.getOptionValue(OPT_CERT_LONG));
            credentialsNotRetrieved = false;
        }
        if (commandLine.hasOption(OPT_KEY_LONG)) {
            if (commandLine.hasOption(OPT_PROXY_LONG)) {
                throw new ParseException(String.format("Conflicting options --%s and --%s.", OPT_PROXY_LONG, OPT_KEY_LONG));
            }
            if (!commandLine.hasOption(OPT_CERT_LONG)) {
                throw new ParseException(String.format("Option --%s requires also option --%s.", OPT_KEY_LONG, OPT_CERT_LONG));
            }
            this.serviceClient.setClientPrivateKey(commandLine.getOptionValue(OPT_KEY_LONG));
            credentialsNotRetrieved = false;
        }
        if (credentialsNotRetrieved) {
            String euid = this.getEUID();
            if (euid == null) {
                log.error("Cannot enstabilish user's effective user id.");
                throw new PAPException(String.format("Cannot enstabilish user's effective user id, please use the --%s or --%s, --%s options.", OPT_PROXY_LONG, OPT_CERT_LONG, OPT_KEY_LONG));
            }
            String messageString = null;
            if ("0".equals(euid)) {
                if (this.setCertFromEnvironment()) {
                    messageString = String.format("Connecting to %s using %s and %s (from environment X509_USER_CERT and X509_USER_KEY)", this.serviceClient.getTargetEndpoint(), this.serviceClient.getClientCertificate(), this.serviceClient.getClientPrivateKey());
                } else {
                    this.serviceClient.setClientCertificate("/etc/grid-security/hostcert.pem");
                    this.serviceClient.setClientPrivateKey("/etc/grid-security/hostkey.pem");
                    messageString = String.format("Connecting to %s using %s and %s", this.serviceClient.getTargetEndpoint(), this.serviceClient.getClientCertificate(), this.serviceClient.getClientPrivateKey());
                }
            } else if (this.setProxyFromEnvironment()) {
                messageString = String.format("Connecting to %s using proxy (from environment X509_USER_PROXY)  %s", this.serviceClient.getTargetEndpoint(), this.serviceClient.getClientProxy());
            } else if (this.setCertFromEnvironment()) {
                messageString = String.format("Connecting to %s using %s and %s (from environment X509_USER_CERT and X509_USER_KEY)", this.serviceClient.getTargetEndpoint(), this.serviceClient.getClientCertificate(), this.serviceClient.getClientPrivateKey());
            } else if (this.setProxyFromStandardLocation(euid)) {
                messageString = String.format("Connecting to %s using proxy %s", this.serviceClient.getTargetEndpoint(), this.serviceClient.getClientProxy());
            } else if (this.setCertFromHomeDir()) {
                messageString = String.format("Connecting to %s using %s and %s", this.serviceClient.getTargetEndpoint(), this.serviceClient.getClientCertificate(), this.serviceClient.getClientPrivateKey());
            } else {
                throw new ParseException(String.format("Unable to find a certificate or a proxy, please specify a proxy file with option --%s or certificate and key with options --%s and --%s", OPT_PROXY_LONG, OPT_CERT_LONG, OPT_KEY_LONG));
            }
            log.info(messageString);
            if (this.verboseMode) {
                System.out.println(messageString);
            }
        }
        if (this.serviceClient.getClientPrivateKey() != null && (keyPassword = this.getPrivateKeyPasswordFromConsole(this.serviceClient.getClientPrivateKey(), this.serviceClient.getClientCertificate())) != null) {
            this.serviceClient.setClientPrivateKeyPassword(keyPassword);
        }
        return this.executeCommandService(commandLine, this.serviceClient);
    }

    private String getPrivateKeyPasswordFromConsole(String keyFile, String certFile) {
        String prompt = "Please enter the passphrase for the private key file " + keyFile + ": ";
        ConsolePasswordFinder pf = new ConsolePasswordFinder(prompt);
        try {
            new PEMCredential((InputStream)new FileInputStream(keyFile), (InputStream)new FileInputStream(certFile), (PasswordFinder)pf);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PAPException(e.getMessage(), e);
        }
        return pf.getLastReadPassword();
    }

    public String[] getCommandNameValues() {
        return this.commandNameValues;
    }

    public ServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public void printHelpMessage(PrintWriter pw) {
        String syntax = String.format("pap-admin [global-options] %s %s", this.commandNameValues[0], this.usageText);
        pw.println();
        helpFormatter.printUsage(pw, helpFormatter.getWidth(), syntax);
        if (this.descriptionText != null) {
            pw.println();
            helpFormatter.printWrapped(pw, helpFormatter.getWidth(), this.descriptionText);
        }
        if (this.longDescriptionText != null) {
            pw.println();
            helpFormatter.printWrapped(pw, helpFormatter.getWidth(), this.longDescriptionText);
        }
        pw.println();
        helpFormatter.printWrapped(pw, helpFormatter.getWidth(), "Valid options:");
        helpFormatter.printOptions(pw, helpFormatter.getWidth(), this.commandOptions, helpFormatter.getLeftPadding(), helpFormatter.getDescPadding());
        pw.println();
        helpFormatter.printWrapped(pw, helpFormatter.getWidth(), "Global options:");
        helpFormatter.printOptions(pw, helpFormatter.getWidth(), globalOptions, helpFormatter.getLeftPadding(), helpFormatter.getDescPadding());
    }

    protected abstract Options defineCommandOptions();

    protected abstract int executeCommandService(CommandLine var1, ServiceClient var2) throws CLIException, ParseException, RemoteException;

    protected void printErrorMessage(String msg) {
        System.out.println(msg);
    }

    protected void printOutputMessage(String msg) {
        System.out.println(msg);
    }

    protected void printVerboseMessage(String msg) {
        if (this.verboseMode) {
            System.out.println(msg);
        }
    }

    private String getEUID() {
        String euid = System.getenv("EUID");
        if (!Utils.isDefined(euid)) {
            String euidProperty = System.getProperty("effectiveUserId");
            euid = Utils.isDefined(euidProperty) ? euidProperty : null;
        }
        return euid;
    }

    private boolean setCertFromHomeDir() throws ParseException {
        String baseDir = System.getProperty("user.home") + File.separator + ".globus" + File.separator;
        String cert = baseDir + "usercert.pem";
        String key = baseDir + "userkey.pem";
        File file = new File(cert);
        if (!file.exists()) {
            return false;
        }
        file = new File(key);
        if (!file.exists()) {
            return false;
        }
        this.serviceClient.setClientCertificate(cert);
        this.serviceClient.setClientPrivateKey(key);
        return true;
    }

    private boolean setCertFromEnvironment() throws ParseException {
        String x509UserCert = System.getenv("X509_USER_CERT");
        String x509UserKey = System.getenv("X509_USER_KEY");
        if (!Utils.isDefined(x509UserCert) && !Utils.isDefined(x509UserKey)) {
            return false;
        }
        if (!Utils.isDefined(x509UserCert) || !Utils.isDefined(x509UserKey)) {
            if (Utils.isDefined(x509UserCert)) {
                throw new ParseException("Trying to use environment variable X509_USER_CERT for certificate but environment variable X509_USER_KEY is not set.");
            }
            throw new ParseException("Trying to use environment variable X509_USER_KEY for private key but environment variable X509_USER_CERT is not set.");
        }
        this.serviceClient.setClientCertificate(x509UserCert);
        this.serviceClient.setClientPrivateKey(x509UserKey);
        return true;
    }

    private boolean setProxyFromEnvironment() {
        String x509UserProxy = System.getenv("X509_USER_PROXY");
        if (Utils.isDefined(x509UserProxy)) {
            this.serviceClient.setClientProxy(x509UserProxy);
            return true;
        }
        return false;
    }

    private boolean setProxyFromStandardLocation(String euid) {
        String proxy = "/tmp/x509up_u" + euid;
        File file = new File(proxy);
        if (!file.exists()) {
            return false;
        }
        this.serviceClient.setClientProxy(proxy);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExitStatus {
        SUCCESS,
        PARTIAL_SUCCESS,
        FAILURE,
        INITIALIZATION_ERROR,
        PARSE_ERROR,
        REMOTE_EXCEPTION;

    }
}

