/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.ui.cli;

import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.security.cert.CertificateException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.glite.authz.pap.ui.cli.HelpMessageException;
import org.glite.authz.pap.ui.cli.ServiceCLI;
import org.glite.authz.pap.ui.cli.authzmanagement.AddACE;
import org.glite.authz.pap.ui.cli.authzmanagement.ListACL;
import org.glite.authz.pap.ui.cli.authzmanagement.RemoveACE;
import org.glite.authz.pap.ui.cli.papmanagement.AddPap;
import org.glite.authz.pap.ui.cli.papmanagement.DisablePap;
import org.glite.authz.pap.ui.cli.papmanagement.EnablePap;
import org.glite.authz.pap.ui.cli.papmanagement.GetOrder;
import org.glite.authz.pap.ui.cli.papmanagement.GetPollingInterval;
import org.glite.authz.pap.ui.cli.papmanagement.ListPaps;
import org.glite.authz.pap.ui.cli.papmanagement.Ping;
import org.glite.authz.pap.ui.cli.papmanagement.RefreshCache;
import org.glite.authz.pap.ui.cli.papmanagement.RemovePap;
import org.glite.authz.pap.ui.cli.papmanagement.SetOrder;
import org.glite.authz.pap.ui.cli.papmanagement.SetPollingInterval;
import org.glite.authz.pap.ui.cli.papmanagement.UpdatePap;
import org.glite.authz.pap.ui.cli.policymanagement.AddObligation;
import org.glite.authz.pap.ui.cli.policymanagement.AddPoliciesFromFile;
import org.glite.authz.pap.ui.cli.policymanagement.AddPolicy;
import org.glite.authz.pap.ui.cli.policymanagement.BanAttribute;
import org.glite.authz.pap.ui.cli.policymanagement.ListPolicies;
import org.glite.authz.pap.ui.cli.policymanagement.Move;
import org.glite.authz.pap.ui.cli.policymanagement.RemoveAllPolicies;
import org.glite.authz.pap.ui.cli.policymanagement.RemoveObligation;
import org.glite.authz.pap.ui.cli.policymanagement.RemovePolicies;
import org.glite.authz.pap.ui.cli.policymanagement.UnBanAttribute;
import org.glite.authz.pap.ui.cli.policymanagement.UpdatePolicy;
import org.glite.authz.pap.ui.cli.samlclient.SAMLClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAPCLI {
    public static final String DEFAULTS_FILE_NAME = "pap-admin.properties";
    private static final Logger log = LoggerFactory.getLogger(PAPCLI.class);
    private final List<ServiceCLI> serviceCLIList = new LinkedList<ServiceCLI>();
    private final List<ServiceCLI> policyMgmtCommandList = new LinkedList<ServiceCLI>();
    private final List<ServiceCLI> papMgmtCommandList = new LinkedList<ServiceCLI>();
    private final List<ServiceCLI> authzMgmtCommandList = new LinkedList<ServiceCLI>();
    private final List<ServiceCLI> testCommandList = new LinkedList<ServiceCLI>();
    protected int hfWidth = 80;
    protected Options options = null;
    protected final CommandLineParser parser = new GnuParser();
    protected final HelpFormatter helpFormatter = new HelpFormatter();
    protected ServiceCLI serviceCLI = null;
    protected String[] args;
    protected boolean printGeneralHelpMessage = false;

    public static void main(String[] args) {
        CertificateUtils.configureSecProvider();
        PAPCLI cli = new PAPCLI(args);
        try {
            cli.parseCommandLine();
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
        }
        int exitStatus = cli.executeCommand();
        for (ServiceCLI.ExitStatus es : ServiceCLI.ExitStatus.values()) {
            if (es.ordinal() != exitStatus) continue;
            log.info(String.format("Exit status (%s): %s %d", cli.getCommandName(), es.toString(), exitStatus));
        }
        System.exit(exitStatus);
    }

    public PAPCLI(String[] args) {
        this.args = args;
        this.helpFormatter.setLeftPadding(4);
        this.defineCommands();
        this.defineOptions();
        this.loadDefaults();
    }

    private void loadDefaults() {
        String papDefaultsLocation;
        File adminDefaultsFile;
        String papHome = System.getProperty("PAP_HOME");
        if (papHome == null || "".equals(papHome)) {
            System.err.println("Please define the PAP_HOME environment variable according to your PAP installation before running this program!");
            System.exit(ServiceCLI.ExitStatus.INITIALIZATION_ERROR.ordinal());
        }
        if ((adminDefaultsFile = new File(papDefaultsLocation = papHome + "/conf/" + DEFAULTS_FILE_NAME)).exists() && adminDefaultsFile.canRead()) {
            Properties adminDefaultProps = new Properties();
            try {
                adminDefaultProps.load(new FileReader(adminDefaultsFile));
                System.getProperties().putAll((Map<?, ?>)adminDefaultProps);
            }
            catch (IOException e) {
                System.err.println("Error loading pap-admin default properties file '" + papDefaultsLocation + "': " + e.getMessage());
                System.err.println("Continuing...");
            }
        } else {
            log.warn("Pap admin default properties file not found or unreadable at location: " + papDefaultsLocation);
        }
    }

    public int executeCommand() {
        int exitStatus;
        if (this.printGeneralHelpMessage) {
            this.printGeneralHelp();
            return ServiceCLI.ExitStatus.SUCCESS.ordinal();
        }
        if (this.serviceCLI == null) {
            return ServiceCLI.ExitStatus.INITIALIZATION_ERROR.ordinal();
        }
        try {
            exitStatus = System.getProperty("enablePapCliProfiling") != null ? this.profileCommandExecution(this.serviceCLI, this.args) : this.serviceCLI.execute(this.args);
        }
        catch (ParseException e) {
            System.err.println("\nParse error: " + e.getMessage() + "\n");
            return ServiceCLI.ExitStatus.PARSE_ERROR.ordinal();
        }
        catch (HelpMessageException e) {
            this.printCommandHelp(this.serviceCLI);
            return ServiceCLI.ExitStatus.SUCCESS.ordinal();
        }
        catch (RemoteException e) {
            log.error("Remote exception", (Throwable)e);
            String errorMessage = e.getMessage();
            if (e.getCause() != null) {
                log.error("Remote exception cause:", e.getCause());
                String errorMessagePrefix = "Error";
                if (e.getCause() instanceof CertificateException) {
                    errorMessagePrefix = String.format("Certificate error: bad password or bad certificate/key (%s, %s)", this.serviceCLI.getServiceClient().getClientCertificate(), this.serviceCLI.getServiceClient().getClientPrivateKey());
                } else if (e.getCause() instanceof SocketException) {
                    errorMessagePrefix = "Error contacting the PAP service";
                } else if (e.getCause() instanceof SSLPeerUnverifiedException) {
                    errorMessagePrefix = "SSL authentication error";
                }
                errorMessage = String.format("%s. Caused by %s: %s", errorMessagePrefix, e.getCause().getClass().getName(), e.getCause().getMessage());
                if (!errorMessage.endsWith(".")) {
                    errorMessage = String.format("%s.", errorMessage);
                }
            }
            System.out.println(errorMessage);
            return ServiceCLI.ExitStatus.REMOTE_EXCEPTION.ordinal();
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            log.error("admin exception", (Throwable)e);
            return ServiceCLI.ExitStatus.FAILURE.ordinal();
        }
        return exitStatus;
    }

    public void parseCommandLine() throws ParseException {
        String command;
        CommandLine commandLine = this.parser.parse(this.options, this.args, true);
        this.printGeneralHelpMessage = commandLine.hasOption('h');
        try {
            command = this.getCommand(commandLine);
        }
        catch (ParseException e) {
            if (this.printGeneralHelpMessage) {
                return;
            }
            throw e;
        }
        boolean commandFound = false;
        for (ServiceCLI this.serviceCLI : this.serviceCLIList) {
            if (!this.serviceCLI.commandMatch(command)) continue;
            commandFound = true;
            break;
        }
        if (!commandFound) {
            this.serviceCLI = null;
            throw new ParseException("Unknown command: " + command);
        }
    }

    public String getCommandName() {
        if (this.serviceCLI != null) {
            return this.serviceCLI.getCommandNameValues()[0];
        }
        return null;
    }

    private void defineCommands() {
        this.policyMgmtCommandList.add(new BanAttribute());
        this.policyMgmtCommandList.add(new UnBanAttribute());
        this.policyMgmtCommandList.add(new AddPolicy());
        this.policyMgmtCommandList.add(new AddPoliciesFromFile());
        this.policyMgmtCommandList.add(new UpdatePolicy());
        this.policyMgmtCommandList.add(new RemovePolicies());
        this.policyMgmtCommandList.add(new RemoveAllPolicies());
        this.policyMgmtCommandList.add(new ListPolicies());
        this.policyMgmtCommandList.add(new Move());
        this.policyMgmtCommandList.add(new AddObligation());
        this.policyMgmtCommandList.add(new RemoveObligation());
        this.papMgmtCommandList.add(new Ping());
        this.papMgmtCommandList.add(new AddPap());
        this.papMgmtCommandList.add(new RemovePap());
        this.papMgmtCommandList.add(new UpdatePap());
        this.papMgmtCommandList.add(new ListPaps());
        this.papMgmtCommandList.add(new EnablePap());
        this.papMgmtCommandList.add(new DisablePap());
        this.papMgmtCommandList.add(new RefreshCache());
        this.papMgmtCommandList.add(new GetOrder());
        this.papMgmtCommandList.add(new SetOrder());
        this.papMgmtCommandList.add(new GetPollingInterval());
        this.papMgmtCommandList.add(new SetPollingInterval());
        this.authzMgmtCommandList.add(new ListACL());
        this.authzMgmtCommandList.add(new AddACE());
        this.authzMgmtCommandList.add(new RemoveACE());
        this.testCommandList.add(new SAMLClient());
        this.serviceCLIList.addAll(this.policyMgmtCommandList);
        this.serviceCLIList.addAll(this.papMgmtCommandList);
        this.serviceCLIList.addAll(this.authzMgmtCommandList);
        this.serviceCLIList.addAll(this.testCommandList);
    }

    private void defineOptions() {
        this.options = ServiceCLI.getGlobalOptions();
        this.options.addOption("h", "help", false, "Print this message");
    }

    private String getCommandStringHelpMessage(String[] commandNameValues) {
        String commandString = this.fillWithSpaces(this.helpFormatter.getLeftPadding()) + commandNameValues[0];
        if (commandNameValues.length > 1) {
            commandString = commandString + " (";
            for (int i = 1; i < commandNameValues.length; ++i) {
                commandString = commandString + commandNameValues[i];
                if (i >= commandNameValues.length - 1) continue;
                commandString = commandString + ", ";
            }
            commandString = commandString + ")";
        }
        return commandString;
    }

    private void printCommandHelp(ServiceCLI serviceCLI) {
        PrintWriter pw = new PrintWriter(System.out);
        serviceCLI.printHelpMessage(pw);
        pw.println();
        pw.flush();
    }

    private void printGeneralHelp() {
        PrintWriter pw = new PrintWriter(System.out);
        pw.println();
        this.helpFormatter.printUsage(pw, this.helpFormatter.getWidth(), "pap-admin [global-options] <command> [options] [args]");
        pw.println();
        this.helpFormatter.printWrapped(pw, this.helpFormatter.getWidth(), "PAP command-line client.");
        this.helpFormatter.printWrapped(pw, this.helpFormatter.getWidth(), "Type 'pap-admin <subcommand> -h' for help on a specific subcommand.");
        pw.println();
        this.helpFormatter.printWrapped(pw, this.helpFormatter.getWidth(), "Global options:");
        this.helpFormatter.printOptions(pw, this.helpFormatter.getWidth(), this.options, this.helpFormatter.getLeftPadding(), this.helpFormatter.getDescPadding());
        pw.println();
        this.helpFormatter.printWrapped(pw, this.helpFormatter.getWidth(), "List of available subcommands grouped by category.");
        pw.println();
        this.helpFormatter.printWrapped(pw, this.helpFormatter.getWidth(), "Policy management:");
        for (ServiceCLI serviceCLI : this.policyMgmtCommandList) {
            this.helpFormatter.printWrapped(pw, this.hfWidth, this.getCommandStringHelpMessage(serviceCLI.getCommandNameValues()));
        }
        pw.println();
        this.helpFormatter.printWrapped(pw, this.helpFormatter.getWidth(), "Distribution management:");
        for (ServiceCLI serviceCLI : this.papMgmtCommandList) {
            this.helpFormatter.printWrapped(pw, this.hfWidth, this.getCommandStringHelpMessage(serviceCLI.getCommandNameValues()));
        }
        pw.println();
        this.helpFormatter.printWrapped(pw, this.helpFormatter.getWidth(), "Authorization management:");
        for (ServiceCLI serviceCLI : this.authzMgmtCommandList) {
            this.helpFormatter.printWrapped(pw, this.hfWidth, this.getCommandStringHelpMessage(serviceCLI.getCommandNameValues()));
        }
        pw.println();
        this.helpFormatter.printWrapped(pw, this.helpFormatter.getWidth(), "Test utils:");
        for (ServiceCLI serviceCLI : this.testCommandList) {
            this.helpFormatter.printWrapped(pw, this.hfWidth, this.getCommandStringHelpMessage(serviceCLI.getCommandNameValues()));
        }
        pw.println();
        pw.flush();
    }

    protected long computeAvg(long[] values) {
        long avg = 0L;
        for (int i = 1; i < values.length; ++i) {
            avg = (values[i] + avg) / 2L;
        }
        return avg;
    }

    protected String fillWithSpaces(int n) {
        String s = "";
        for (int i = 0; i < n; ++i) {
            s = s + " ";
        }
        return s;
    }

    protected String getCommand(CommandLine commandLine) throws ParseException {
        String[] args = commandLine.getArgs();
        if (args.length == 0) {
            throw new ParseException("Missing command");
        }
        return args[0];
    }

    protected int profileCommandExecution(ServiceCLI serviceCLI, String[] args) throws HelpMessageException, RemoteException, ParseException {
        int status = ServiceCLI.ExitStatus.FAILURE.ordinal();
        int numSamples = 10;
        long[] samples = new long[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            long cmdFoundTime = System.currentTimeMillis();
            status = serviceCLI.execute(args);
            samples[i] = System.currentTimeMillis() - cmdFoundTime;
        }
        log.debug("Avg '" + serviceCLI.getClass().getSimpleName() + "'cmd execution time: " + this.computeAvg(samples) + " msecs.");
        log.debug("Fist '" + serviceCLI.getClass().getSimpleName() + "' execution (bootstrap) time: " + samples[0] + " msecs.");
        return status;
    }
}

