/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.services;

import java.rmi.RemoteException;
import org.glite.authz.pap.authz.operations.policymanagement.AddPoliciesOperation;
import org.glite.authz.pap.authz.operations.policymanagement.AddPolicyOperation;
import org.glite.authz.pap.authz.operations.policymanagement.AddPolicySetOperation;
import org.glite.authz.pap.authz.operations.policymanagement.GetLocalPolicyOperation;
import org.glite.authz.pap.authz.operations.policymanagement.GetLocalPolicySetOperation;
import org.glite.authz.pap.authz.operations.policymanagement.GetLocalRootPolicySetOperation;
import org.glite.authz.pap.authz.operations.policymanagement.GetRemotePolicyOperation;
import org.glite.authz.pap.authz.operations.policymanagement.GetRemotePolicySetOperation;
import org.glite.authz.pap.authz.operations.policymanagement.GetRemoteRootPolicySetOperation;
import org.glite.authz.pap.authz.operations.policymanagement.HasLocalPolicyOperation;
import org.glite.authz.pap.authz.operations.policymanagement.HasLocalPolicySetOperation;
import org.glite.authz.pap.authz.operations.policymanagement.HasRemotePolicyOperation;
import org.glite.authz.pap.authz.operations.policymanagement.HasRemotePolicySetOperation;
import org.glite.authz.pap.authz.operations.policymanagement.ListLocalPoliciesOperation;
import org.glite.authz.pap.authz.operations.policymanagement.ListLocalPolicySetOperation;
import org.glite.authz.pap.authz.operations.policymanagement.ListRemotePoliciesOperation;
import org.glite.authz.pap.authz.operations.policymanagement.ListRemotePolicySetOperation;
import org.glite.authz.pap.authz.operations.policymanagement.MoveOperation;
import org.glite.authz.pap.authz.operations.policymanagement.RemoveObjectByIdAndReferencesOperation;
import org.glite.authz.pap.authz.operations.policymanagement.RemovePolicyOperation;
import org.glite.authz.pap.authz.operations.policymanagement.RemovePolicySetOperation;
import org.glite.authz.pap.authz.operations.policymanagement.StorePolicyOperation;
import org.glite.authz.pap.authz.operations.policymanagement.StorePolicySetOperation;
import org.glite.authz.pap.authz.operations.policymanagement.UpdatePolicyOperation;
import org.glite.authz.pap.authz.operations.policymanagement.UpdatePolicySetOperation;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.services.ServiceClassExceptionManager;
import org.glite.authz.pap.services.ServicesUtils;
import org.glite.authz.pap.services.xacml_policy_management.axis_skeletons.XACMLPolicyManagement;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XACMLPolicyManagementService
implements XACMLPolicyManagement {
    private static final Logger log = LoggerFactory.getLogger(XACMLPolicyManagementService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] addPolicies(String alias, int index, String policySetId, String[] policyIdPrefixArray, PolicyType[] policyArray) throws RemoteException {
        log.info(String.format("addPolicy(policySetId=\"%s\"\");", policySetId));
        try {
            Object object = ServicesUtils.highLevelOperationLock;
            synchronized (object) {
                return (String[])AddPoliciesOperation.instance(alias, index, policySetId, policyIdPrefixArray, policyArray).execute();
            }
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addPolicy(String alias, int index, String policySetId, String policyIdPrefix, PolicyType policy) throws RemoteException {
        log.info(String.format("addPolicy(policySetId=\"%s\", policyIdPrefix=\"%s\");", policySetId, policyIdPrefix));
        try {
            Object object = ServicesUtils.highLevelOperationLock;
            synchronized (object) {
                return (String)AddPolicyOperation.instance(alias, index, policySetId, policyIdPrefix, policy).execute();
            }
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addPolicySet(String alias, int index, PolicySetType policySet) throws RemoteException {
        log.info(String.format("addPolicySet(policySetId=\"%s\");", policySet.getPolicySetId()));
        try {
            Object object = ServicesUtils.highLevelOperationLock;
            synchronized (object) {
                return (String)AddPolicySetOperation.instance(alias, index, policySet).execute();
            }
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    public PolicySetType getRootPolicySet(String alias) throws RemoteException {
        log.info(String.format("getPAPPolicySet(\"%s\");", alias));
        try {
            Pap ps;
            if (alias == null) {
                alias = "default";
            }
            if ((ps = PapManager.getInstance().getPap(alias)).isLocal()) {
                return (PolicySetType)GetLocalRootPolicySetOperation.instance(ps).execute();
            }
            return (PolicySetType)GetRemoteRootPolicySetOperation.instance(ps).execute();
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    public PolicyType getPolicy(String alias, String policyId) throws RemoteException {
        log.info(String.format("getPolicy(\"%s\");", policyId));
        try {
            Pap ps;
            if (alias == null) {
                alias = "default";
            }
            PolicyType policy = (ps = PapManager.getInstance().getPap(alias)).isLocal() ? (PolicyType)GetLocalPolicyOperation.instance(ps, policyId).execute() : (PolicyType)GetRemotePolicyOperation.instance(ps, policyId).execute();
            return policy;
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    public PolicySetType getPolicySet(String alias, String policySetId) throws RemoteException {
        log.info(String.format("getPolicySet(\"%s\");", policySetId));
        try {
            Pap ps;
            if (alias == null) {
                alias = "default";
            }
            PolicySetType policySet = (ps = PapManager.getInstance().getPap(alias)).isLocal() ? (PolicySetType)GetLocalPolicySetOperation.instance(ps, policySetId).execute() : (PolicySetType)GetRemotePolicySetOperation.instance(ps, policySetId).execute();
            return policySet;
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPolicy(String alias, String policyId) throws RemoteException {
        log.info(String.format("hasPolicy(\"%s\");", policyId));
        try {
            if (alias == null) {
                alias = "default";
            }
            Pap ps = PapManager.getInstance().getPap(alias);
            Object object = ServicesUtils.highLevelOperationLock;
            synchronized (object) {
                if (ps.isLocal()) {
                    return (Boolean)HasLocalPolicyOperation.instance(ps, policyId).execute();
                }
                return (Boolean)HasRemotePolicyOperation.instance(ps, policyId).execute();
            }
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPolicySet(String alias, String policySetId) throws RemoteException {
        log.info(String.format("hasPolicySet(\"%s\");", policySetId));
        try {
            if (alias == null) {
                alias = "default";
            }
            Pap ps = PapManager.getInstance().getPap(alias);
            Object object = ServicesUtils.highLevelOperationLock;
            synchronized (object) {
                if (ps.isLocal()) {
                    return (Boolean)HasLocalPolicySetOperation.instance(ps, policySetId).execute();
                }
                return (Boolean)HasRemotePolicySetOperation.instance(ps, policySetId).execute();
            }
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyType[] listPolicies(String papAlias) throws RemoteException {
        log.info("listPolicies();");
        try {
            if (papAlias == null) {
                papAlias = "default";
            }
            Pap ps = PapManager.getInstance().getPap(papAlias);
            Object object = ServicesUtils.highLevelOperationLock;
            synchronized (object) {
                if (ps.isLocal()) {
                    return (PolicyType[])ListLocalPoliciesOperation.instance(ps).execute();
                }
                return (PolicyType[])ListRemotePoliciesOperation.instance(ps).execute();
            }
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicySetType[] listPolicySets(String papAlias) throws RemoteException {
        log.info("listPolicySets();");
        try {
            if (papAlias == null) {
                papAlias = "default";
            }
            Pap ps = PapManager.getInstance().getPap(papAlias);
            Object object = ServicesUtils.highLevelOperationLock;
            synchronized (object) {
                if (ps.isLocal()) {
                    return (PolicySetType[])ListLocalPolicySetOperation.instance(ps).execute();
                }
                return (PolicySetType[])ListRemotePolicySetOperation.instance(ps).execute();
            }
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(String alias, String id, String pivotId, boolean moveAfter) throws RemoteException {
        log.info(String.format("move(id=\"%s\", pivotId=\"%s\", moveAfter=%b);", id, pivotId, moveAfter));
        try {
            Object object = ServicesUtils.highLevelOperationLock;
            synchronized (object) {
                MoveOperation.instance(alias, id, pivotId, moveAfter).execute();
            }
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeObjectByIdAndReferences(String alias, String id) throws RemoteException {
        log.info(String.format("removeObjectByIdAndReferences(\"%s\");", id));
        try {
            Object object = ServicesUtils.highLevelOperationLock;
            synchronized (object) {
                return (Boolean)RemoveObjectByIdAndReferencesOperation.instance(alias, id).execute();
            }
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePolicy(String alias, String policyId) throws RemoteException {
        log.info(String.format("removePolicy(\"%s\");", policyId));
        try {
            Object object = ServicesUtils.highLevelOperationLock;
            synchronized (object) {
                return (Boolean)RemovePolicyOperation.instance(alias, policyId).execute();
            }
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePolicySet(String alias, String policySetId) throws RemoteException {
        log.info(String.format("removePolicySet(\"%s\");", policySetId));
        try {
            Object object = ServicesUtils.highLevelOperationLock;
            synchronized (object) {
                return (Boolean)RemovePolicySetOperation.instance(alias, policySetId).execute();
            }
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    public String storePolicy(String alias, String idPrefix, PolicyType policy) throws RemoteException {
        log.info("storePolicy();");
        try {
            return (String)StorePolicyOperation.instance(alias, idPrefix, policy).execute();
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    public String storePolicySet(String alias, String idPrefix, PolicySetType policySet) throws RemoteException {
        log.info("storePolicySet();");
        try {
            return (String)StorePolicySetOperation.instance(alias, idPrefix, policySet).execute();
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePolicy(String alias, String version, PolicyType policy) throws RemoteException {
        log.info(String.format("updatePolicy(version=\"%s\", id=\"%s\");", version, policy.getPolicyId()));
        try {
            Object object = ServicesUtils.highLevelOperationLock;
            synchronized (object) {
                return (Boolean)UpdatePolicyOperation.instance(alias, version, policy).execute();
            }
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePolicySet(String alias, String version, PolicySetType policySet) throws RemoteException {
        log.info(String.format("updatePolicySet(version=\"%s\", id=\"%s\");", version, policySet.getPolicySetId()));
        try {
            Object object = ServicesUtils.highLevelOperationLock;
            synchronized (object) {
                return (Boolean)UpdatePolicySetOperation.instance(alias, version, policySet).execute();
            }
        }
        catch (RuntimeException e) {
            ServiceClassExceptionManager.log(log, e);
            throw e;
        }
    }
}

