/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.services;

import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.glite.authz.pap.common.PAPConfiguration;
import org.glite.authz.pap.common.xacml.utils.PolicySetHelper;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.services.provisioning.exceptions.MissingIssuerException;
import org.glite.authz.pap.services.provisioning.exceptions.VersionMismatchException;
import org.glite.authz.pap.services.provisioning.exceptions.WrongFormatIssuerException;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Statement;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.StatusMessage;
import org.opensaml.saml2.core.impl.AssertionBuilder;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.ResponseBuilder;
import org.opensaml.saml2.core.impl.StatusBuilder;
import org.opensaml.saml2.core.impl.StatusCodeBuilder;
import org.opensaml.saml2.core.impl.StatusMessageBuilder;
import org.opensaml.xacml.XACMLObject;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.opensaml.xacml.profile.saml.XACMLPolicyQueryType;
import org.opensaml.xacml.profile.saml.XACMLPolicyStatementType;
import org.opensaml.xacml.profile.saml.impl.XACMLPolicyStatementTypeImplBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicesUtils {
    private static Logger logger = LoggerFactory.getLogger(ServicesUtils.class);
    public static final Object highLevelOperationLock = new Object();

    public static void checkQuery(XACMLPolicyQueryType query) throws VersionMismatchException, MissingIssuerException, WrongFormatIssuerException {
        if (query.getVersion() != SAMLVersion.VERSION_20) {
            throw new VersionMismatchException();
        }
        Issuer issuer = query.getIssuer();
        if (issuer == null) {
            throw new MissingIssuerException();
        }
        String issuerFormat = issuer.getFormat();
        if (issuerFormat != null && !issuerFormat.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new WrongFormatIssuerException(issuerFormat);
        }
    }

    public static Response createErrorResponse(XACMLPolicyQueryType inResponseTo, Exception e) {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        ResponseBuilder responseBuilder = (ResponseBuilder)builderFactory.getBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response response = responseBuilder.buildObject();
        response.setID("_" + UUID.randomUUID().toString());
        response.setVersion(SAMLVersion.VERSION_20);
        response.setIssueInstant(new DateTime());
        response.setInResponseTo(inResponseTo.getID());
        StatusBuilder statusBuilder = (StatusBuilder)builderFactory.getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Status status = statusBuilder.buildObject();
        StatusCodeBuilder statusCodeBuilder = (StatusCodeBuilder)builderFactory.getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = statusCodeBuilder.buildObject();
        if (e instanceof VersionMismatchException) {
            statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:VersionMismatch");
        } else if (e instanceof MissingIssuerException || e instanceof WrongFormatIssuerException) {
            statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Requester");
            if (e.getMessage() != null) {
                StatusMessageBuilder statusMessageBuilder = (StatusMessageBuilder)builderFactory.getBuilder(StatusMessage.DEFAULT_ELEMENT_NAME);
                StatusMessage statusMessage = statusMessageBuilder.buildObject();
                statusMessage.setMessage(e.getMessage());
                status.setStatusMessage(statusMessage);
            }
        } else {
            statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Responder");
        }
        status.setStatusCode(statusCode);
        response.setStatus(status);
        return response;
    }

    public static Response createResponse(XACMLPolicyQueryType inResponseTo, List<XACMLObject> policyObjects, HttpServletRequest request) {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        ResponseBuilder responseBuilder = (ResponseBuilder)builderFactory.getBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response response = responseBuilder.buildObject();
        response.setID("_" + UUID.randomUUID().toString());
        response.setVersion(SAMLVersion.VERSION_20);
        response.setIssueInstant(new DateTime());
        response.setInResponseTo(inResponseTo.getID());
        AssertionBuilder assertionBuilder = (AssertionBuilder)builderFactory.getBuilder(Assertion.DEFAULT_ELEMENT_NAME);
        Assertion assertion = assertionBuilder.buildObject();
        assertion.setID("_" + UUID.randomUUID().toString());
        assertion.setVersion(SAMLVersion.VERSION_20);
        assertion.setIssueInstant(new DateTime());
        IssuerBuilder issuerBuilder = (IssuerBuilder)builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = issuerBuilder.buildObject();
        String defaultEntityId = String.format("%s://%s:%s/%s/services/ProvisioningService", request.getScheme(), request.getServerName(), request.getServerPort(), "pap");
        PAPConfiguration conf = PAPConfiguration.instance();
        String issuerValue = conf.getString("standalone-service.entity_id", defaultEntityId);
        issuer.setValue(issuerValue);
        assertion.setIssuer(issuer);
        XACMLPolicyStatementTypeImplBuilder policyStatementBuilder = (XACMLPolicyStatementTypeImplBuilder)builderFactory.getBuilder(XACMLPolicyStatementType.TYPE_NAME_XACML20);
        XACMLPolicyStatementType policyStatement = (XACMLPolicyStatementType)policyStatementBuilder.buildObject(Statement.DEFAULT_ELEMENT_NAME, XACMLPolicyStatementType.TYPE_NAME_XACML20);
        for (XACMLObject xacmlObject : policyObjects) {
            if (xacmlObject instanceof PolicySetType) {
                policyStatement.getPolicySets().add((PolicySetType)xacmlObject);
            } else {
                policyStatement.getPolicies().add((PolicyType)xacmlObject);
            }
            assertion.getStatements().add(policyStatement);
        }
        response.getAssertions().add(assertion);
        StatusBuilder statusBuilder = (StatusBuilder)builderFactory.getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Status status = statusBuilder.buildObject();
        StatusCodeBuilder statusCodeBuilder = (StatusCodeBuilder)builderFactory.getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = statusCodeBuilder.buildObject();
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        status.setStatusCode(statusCode);
        response.setStatus(status);
        return response;
    }

    public static PolicySetType makeRootPolicySet() {
        String rootPolicySetId = "root-" + PapManager.getInstance().getPap("default").getId();
        PolicySetType rootPolicySet = PolicySetHelper.buildWithAnyTarget(rootPolicySetId, "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:first-applicable");
        rootPolicySet.setVersion("1");
        return rootPolicySet;
    }
}

