/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.services;

import java.rmi.RemoteException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.glite.authz.pap.authz.operations.policyprovisioning.GetPoliciesForPAPOperation;
import org.glite.authz.pap.authz.operations.policyprovisioning.GetPoliciesForPDPOperation;
import org.glite.authz.pap.common.xacml.utils.XMLObjectHelper;
import org.glite.authz.pap.services.ServiceClassExceptionManager;
import org.glite.authz.pap.services.ServicesUtils;
import org.glite.authz.pap.services.provisioning.axis_skeletons.Provisioning;
import org.glite.authz.pap.services.provisioning.exceptions.MissingIssuerException;
import org.glite.authz.pap.services.provisioning.exceptions.VersionMismatchException;
import org.glite.authz.pap.services.provisioning.exceptions.WrongFormatIssuerException;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.core.Response;
import org.opensaml.xacml.profile.saml.XACMLPolicyQueryType;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvisioningService
implements Provisioning {
    private final Logger log = LoggerFactory.getLogger(ProvisioningService.class);
    private static final Object lock = new Object();

    public Response XACMLPolicyQuery(XACMLPolicyQueryType query) throws RemoteException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)MessageContext.getCurrentContext().getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        Object object = lock;
        synchronized (object) {
            try {
                this.log.trace("Received XACLMPolicyQuery " + XMLObjectHelper.toString((XMLObject)query));
                try {
                    ServicesUtils.checkQuery(query);
                }
                catch (VersionMismatchException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    return ServicesUtils.createErrorResponse(query, e);
                }
                catch (MissingIssuerException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    return ServicesUtils.createErrorResponse(query, e);
                }
                catch (WrongFormatIssuerException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    return ServicesUtils.createErrorResponse(query, e);
                }
                List resultList = null;
                Extensions extensions = query.getExtensions();
                resultList = extensions == null ? (List)GetPoliciesForPDPOperation.instance().execute() : (List)GetPoliciesForPAPOperation.instance().execute();
                Response response = ServicesUtils.createResponse(query, resultList, httpServletRequest);
                this.log.trace("Sending Response : " + XMLObjectHelper.toString((XMLObject)query));
                return response;
            }
            catch (RuntimeException e) {
                ServiceClassExceptionManager.log(this.log, e);
                throw e;
            }
        }
    }
}

