/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.server.standalone;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.glite.authz.pap.common.PAPConfiguration;
import org.slf4j.LoggerFactory;

public class ShutdownClient {
    static void printErrorMessageAndExit(Exception e) {
        System.err.println("PAP shutdown error: " + e.getMessage());
        System.exit(1);
    }

    static void doShutdown() {
        PAPConfiguration conf = PAPConfiguration.instance();
        String shutdownEndpoint = String.format("http://localhost:%s/shutdown", conf.getString("standalone-service.shutdown_port"));
        String shutdownCommand = conf.getString("standalone-service.shutdown_command");
        HttpClient httpClient = new HttpClient();
        GetMethod get = new GetMethod(shutdownEndpoint);
        if (shutdownCommand != null) {
            get.setRequestHeader(new Header("PAP_SHUTDOWN_COMMAND", shutdownCommand));
        }
        try {
            httpClient.executeMethod((HttpMethod)get);
        }
        catch (Exception e) {
            ShutdownClient.printErrorMessageAndExit(e);
        }
    }

    private static void disableLogBackLibraryLogging() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger rootLogger = lc.getLogger("ROOT");
        rootLogger.setLevel(Level.OFF);
    }

    private static void disableLibraryLogging() {
    }

    public static void main(String[] args) {
        ShutdownClient.disableLibraryLogging();
        if (System.getProperty("PAP_HOME") == null) {
            System.err.println("Please set the PAP_HOME environment variable before running this command!");
            System.exit(1);
        }
        try {
            String papConfigurationHome = System.getProperty("PAP_HOME") + "/conf";
            PAPConfiguration.initialize(papConfigurationHome);
        }
        catch (Throwable t) {
            System.err.println("Error reading PAP configuration. Is the PAP_HOME system property/environment variable set correctly?");
            System.err.println(t.getMessage());
            t.printStackTrace(System.err);
            System.exit(1);
        }
        ShutdownClient.doShutdown();
    }
}

