/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.server;

import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import org.glite.authz.pap.authz.AuthorizationEngine;
import org.glite.authz.pap.common.PAPConfiguration;
import org.glite.authz.pap.common.Version;
import org.glite.authz.pap.common.exceptions.PAPConfigurationException;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizardTypeConfiguration;
import org.glite.authz.pap.distribution.DistributionModule;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.repository.RepositoryManager;
import org.glite.authz.pap.repository.RepositoryUtils;
import org.glite.authz.pap.repository.exceptions.RepositoryException;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.DefaultBootstrap;
import org.opensaml.xml.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PAPService {
    static final Logger logger = LoggerFactory.getLogger(PAPService.class);

    protected static void setStartupMonitoringProperties() {
        GregorianCalendar c = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        DateTime dt = new DateTime(c.getTimeInMillis()).withChronology((Chronology)ISOChronology.getInstanceUTC());
        PAPConfiguration.instance().setMonitoringProperty("ServiceStartupTimeMillis", c.getTimeInMillis());
        PAPConfiguration.instance().setMonitoringProperty("ServiceStartupTime", dt);
        PapManager papManager = PapManager.getInstance();
        int numberOfLocalPolicies = 0;
        for (PapContainer papContainer : PapContainer.getContainers(papManager.getLocalPaps())) {
            numberOfLocalPolicies += papContainer.getNumberOfPolicies();
        }
        PAPConfiguration.instance().setMonitoringProperty("NumberOfLocalPolicies", numberOfLocalPolicies);
        int numOfRemotePolicies = 0;
        for (PapContainer papContainer : PapContainer.getContainers(papManager.getRemotePaps())) {
            numOfRemotePolicies += papContainer.getNumberOfPolicies();
        }
        PAPConfiguration.instance().setMonitoringProperty("NumberOfRemotePolicies", numOfRemotePolicies);
        PAPConfiguration.instance().setMonitoringProperty("NumberOfPolicies", numberOfLocalPolicies + numOfRemotePolicies);
        String policyLastModificationTimeString = papManager.getPap("default").getPolicyLastModificationTimeInMilliseconds();
        DateTime policyLastModificationTime = new DateTime(Long.parseLong(policyLastModificationTimeString)).withChronology((Chronology)ISOChronology.getInstanceUTC());
        PAPConfiguration.instance().setMonitoringProperty("PolicyLastModificationTimeMillis", policyLastModificationTimeString);
        PAPConfiguration.instance().setMonitoringProperty("PolicyLastModificationTime", policyLastModificationTime);
    }

    public static void start(ServletContext context) {
        boolean performRepositoryValidationCheck;
        logger.info("Starting PAP service version {} ...", (Object)Version.getServiceVersion());
        PAPConfiguration conf = PAPConfiguration.initialize(context);
        logger.info("Starting authorization engine...");
        AuthorizationEngine.initialize(conf.getPapAuthzConfigurationFileName());
        try {
            logger.info("Bootstraping OpenSAML...");
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            logger.error("Error configuring OpenSAML:" + e.getMessage());
            throw new PAPConfigurationException("Error configuring OpenSAML:" + e.getMessage(), e);
        }
        String configFileName = PAPConfiguration.instance().getPAPConfigurationDir() + "/attribute-mappings.ini";
        AttributeWizardTypeConfiguration.bootstrap(configFileName);
        logger.info("Starting repository manager...");
        RepositoryManager.bootstrap();
        PapManager.initialize();
        try {
            performRepositoryValidationCheck = PAPConfiguration.instance().getBoolean("repository.consistency_check");
        }
        catch (NoSuchElementException e) {
            performRepositoryValidationCheck = false;
            logger.info("Skipping repository validation check");
        }
        if (performRepositoryValidationCheck) {
            boolean repair;
            try {
                repair = PAPConfiguration.instance().getBoolean("repository.consistency_check.repair");
            }
            catch (NoSuchElementException e) {
                repair = false;
            }
            logger.info("Starting repository validation. repair=" + repair);
            if (!RepositoryUtils.performAllChecks(repair)) {
                throw new RepositoryException("Repository validation check failed");
            }
        }
        PAPService.setStartupMonitoringProperties();
        logger.info("Starting pap distribution module...");
        DistributionModule.getInstance().startDistributionModule();
    }

    public static void stop() {
        logger.info("Shutting down PAP service...");
        logger.info("Shutting down distribution module...");
        DistributionModule.getInstance().stopDistributionModule();
        logger.info("Shutting down authorization module...");
        if (AuthorizationEngine.instance() != null) {
            AuthorizationEngine.instance().shutdown();
        }
        logger.info("Disposing CANL validator...");
        if (PAPConfiguration.instance().getCertchainValidator() != null) {
            PAPConfiguration.instance().getCertchainValidator().dispose();
        }
        logger.info("PAP service stopped.");
    }
}

