/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.repository.dao.filesystem;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glite.authz.pap.common.xacml.impl.PolicySetTypeString;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.utils.PolicySetHelper;
import org.glite.authz.pap.repository.dao.PolicySetDAO;
import org.glite.authz.pap.repository.dao.filesystem.FileSystemRepositoryManager;
import org.glite.authz.pap.repository.exceptions.AlreadyExistsException;
import org.glite.authz.pap.repository.exceptions.InvalidVersionException;
import org.glite.authz.pap.repository.exceptions.NotFoundException;
import org.glite.authz.pap.repository.exceptions.RepositoryException;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemPolicySetDAO
implements PolicySetDAO {
    private static final Logger log = LoggerFactory.getLogger(FileSystemPolicySetDAO.class);
    private static final Map<String, Map<String, PolicySetTypeString>> cache = new ConcurrentHashMap<String, Map<String, PolicySetTypeString>>();
    private static final PolicySetHelper policySetHelper = PolicySetHelper.getInstance();
    private static FileSystemPolicySetDAO instance = null;

    private FileSystemPolicySetDAO() {
    }

    public static FileSystemPolicySetDAO getInstance() {
        if (instance == null) {
            instance = new FileSystemPolicySetDAO();
        }
        return instance;
    }

    private static String getPolicySetAbsolutePath(String papId, String policySetId) {
        return FileSystemRepositoryManager.getPAPDirAbsolutePath(papId) + FileSystemPolicySetDAO.getPolicySetFileName(policySetId);
    }

    private static String getPolicySetFileName(String policySetId) {
        return "PolicySet_" + policySetId + ".xml";
    }

    private static String getPolicySetIdFromFileName(String fileName) {
        int start = "PolicySet_".length();
        int end = fileName.length() - ".xml".length();
        return fileName.substring(start, end);
    }

    private static String papDirNotFoundExceptionMsg(String papDirPAth) {
        return "Not found PAP directory: " + papDirPAth;
    }

    private static String policySetExceptionMsg(String policySetId) {
        return String.format("policySetId=\"%s\"", policySetId);
    }

    private static String policySetNotFoundExceptionMsg(String policySetId) {
        String msg = "Not found: " + FileSystemPolicySetDAO.policySetExceptionMsg(policySetId);
        return msg;
    }

    @Override
    public synchronized void delete(String papId, String policySetId) {
        File policySetFile;
        Map<String, PolicySetTypeString> papCache = cache.get(papId);
        if (papCache != null) {
            papCache.remove(policySetId);
        }
        if ((policySetFile = new File(FileSystemPolicySetDAO.getPolicySetAbsolutePath(papId, policySetId))).exists()) {
            if (papCache.size() == 0) {
                cache.remove(papId);
            }
            if (!policySetFile.delete()) {
                throw new RepositoryException("Cannot delete file: " + policySetFile.getAbsolutePath());
            }
        } else {
            throw new NotFoundException(FileSystemPolicySetDAO.policySetNotFoundExceptionMsg(policySetId));
        }
    }

    @Override
    public synchronized void deleteAll(String papId) {
        File papDir;
        Map<String, PolicySetTypeString> papCache = cache.get(papId);
        if (papCache != null) {
            papCache.clear();
            cache.remove(papId);
        }
        if (!(papDir = new File(FileSystemRepositoryManager.getPAPDirAbsolutePath(papId))).exists()) {
            throw new RepositoryException(FileSystemPolicySetDAO.papDirNotFoundExceptionMsg(papDir.getAbsolutePath()));
        }
        for (File file : papDir.listFiles()) {
            String fileName;
            if (file.isDirectory() || !(fileName = file.getName()).startsWith("PolicySet_")) continue;
            file.delete();
        }
    }

    @Override
    public synchronized boolean exists(String papId, String policySetId) {
        File policySetFile = new File(FileSystemPolicySetDAO.getPolicySetAbsolutePath(papId, policySetId));
        boolean result = policySetFile.exists();
        log.debug(String.format("PolicySet \"%s\" exists=%s (file=\"%s\")", policySetId, String.valueOf(result), policySetFile.getAbsoluteFile()));
        return result;
    }

    @Override
    public synchronized List<PolicySetType> getAll(String papId) {
        File papDir = new File(FileSystemRepositoryManager.getPAPDirAbsolutePath(papId));
        if (!papDir.exists()) {
            throw new NotFoundException(FileSystemPolicySetDAO.papDirNotFoundExceptionMsg(papDir.getAbsolutePath()));
        }
        Map<String, PolicySetTypeString> papCache = this.getPapCache(papId);
        LinkedList<PolicySetType> policySetList = new LinkedList<PolicySetType>();
        for (File file : papDir.listFiles()) {
            String fileName;
            if (file.isDirectory() || !(fileName = file.getName()).startsWith("PolicySet_")) continue;
            String policySetId = FileSystemPolicySetDAO.getPolicySetIdFromFileName(fileName);
            PolicySetTypeString policySet = papCache.get(policySetId);
            if (policySet == null) {
                try {
                    policySet = new PolicySetTypeString(policySetId, policySetHelper.readFromFileAsString(file));
                    log.debug("getAll(): PolicySet retrieved from file: id=" + policySetId);
                }
                catch (Throwable e) {
                    throw new RepositoryException(e);
                }
                papCache.put(policySetId, policySet);
            } else {
                log.debug("getAll(): PolicySet retrieved from cache: id=" + policySetId);
            }
            policySetList.add(new PolicySetTypeString(policySetId, policySet.getPolicySetString()));
            if (!policySet.isDOMLoaded()) continue;
            log.warn("getAll(): DOM not released for PolicySet id=" + policySetId);
        }
        return policySetList;
    }

    @Override
    public synchronized PolicySetType getById(String papId, String policySetId) {
        Map<String, PolicySetTypeString> papCache = this.getPapCache(papId);
        PolicySetTypeString policySet = papCache.get(policySetId);
        File policySetFile = new File(FileSystemPolicySetDAO.getPolicySetAbsolutePath(papId, policySetId));
        if (policySet == null) {
            if (!policySetFile.exists()) {
                if (papCache.size() == 0) {
                    cache.remove(papId);
                }
                throw new NotFoundException(FileSystemPolicySetDAO.policySetNotFoundExceptionMsg(policySetId));
            }
            try {
                policySet = new PolicySetTypeString(policySetId, policySetHelper.readFromFileAsString(policySetFile));
            }
            catch (Throwable e) {
                throw new RepositoryException(e);
            }
            papCache.put(policySetId, policySet);
            log.debug("getById(): PolicySet retrieved from file: id=" + policySetId);
        } else {
            log.debug("getById(): PolicySet retrieved from cache: id=" + policySetId);
        }
        if (policySet.isDOMLoaded()) {
            log.warn("getById(): DOM not released for PolicySet id=" + policySetId);
        }
        return new PolicySetTypeString(policySetId, policySet.getPolicySetString());
    }

    @Override
    public synchronized void store(String papId, PolicySetType policySet) {
        PolicySetTypeString policySetTypeString = TypeStringUtils.cloneAsPolicySetTypeString(policySet);
        TypeStringUtils.releaseUnneededMemory(policySet);
        File papDir = new File(FileSystemRepositoryManager.getPAPDirAbsolutePath(papId));
        if (!papDir.exists()) {
            throw new NotFoundException(FileSystemPolicySetDAO.papDirNotFoundExceptionMsg(papDir.getAbsolutePath()));
        }
        String policySetId = policySetTypeString.getPolicySetId();
        File policySetFile = new File(FileSystemPolicySetDAO.getPolicySetAbsolutePath(papId, policySetId));
        if (policySetFile.exists()) {
            throw new AlreadyExistsException("Already exists: policySetId=" + policySetId);
        }
        PolicySetHelper.toFile(policySetFile, (XMLObject)policySetTypeString);
        TypeStringUtils.releaseUnneededMemory(policySetTypeString);
        this.getPapCache(papId).put(policySetId, policySetTypeString);
    }

    @Override
    public synchronized void update(String papId, String policySetVersion, PolicySetType newPolicySet) {
        String policySetId = newPolicySet.getPolicySetId();
        File policySetFile = new File(FileSystemPolicySetDAO.getPolicySetAbsolutePath(papId, policySetId));
        if (!policySetFile.exists()) {
            throw new NotFoundException(FileSystemPolicySetDAO.policySetNotFoundExceptionMsg(policySetId));
        }
        Map<String, PolicySetTypeString> papCache = this.getPapCache(papId);
        PolicySetTypeString oldPolicySetString = papCache.get(policySetId);
        if (oldPolicySetString == null) {
            try {
                oldPolicySetString = new PolicySetTypeString((PolicySetType)policySetHelper.buildFromFile(policySetFile));
                log.debug("update(): PolicySet retrieved from file: id=" + policySetId);
            }
            catch (Throwable e) {
                throw new RepositoryException(e);
            }
        } else {
            log.debug("update(): PolicySet retrieved from cache: id=" + policySetId);
        }
        String repositoryVersion = oldPolicySetString.getVersion();
        TypeStringUtils.releaseUnneededMemory(oldPolicySetString);
        if (!repositoryVersion.equals(policySetVersion)) {
            throw new InvalidVersionException(String.format("Attempting to update the wrong version of PolicySetId=\"%s\" (requestedVersion=\"%s\", repositoryVersion=\"%s\")", policySetId, policySetVersion, repositoryVersion));
        }
        PolicySetHelper.toFile(policySetFile, (XMLObject)newPolicySet);
        PolicySetTypeString newPolicySetTypeString = TypeStringUtils.cloneAsPolicySetTypeString(newPolicySet);
        papCache.put(policySetId, newPolicySetTypeString);
    }

    private Map<String, PolicySetTypeString> getPapCache(String papId) {
        Map<String, PolicySetTypeString> papCache = cache.get(papId);
        if (papCache == null) {
            log.debug("New HashMap for papId=" + papId);
            papCache = new ConcurrentHashMap<String, PolicySetTypeString>();
            cache.put(papId, papCache);
        }
        return papCache;
    }
}

