/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.repository.dao.filesystem;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glite.authz.pap.common.xacml.impl.PolicyTypeString;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.utils.PolicyHelper;
import org.glite.authz.pap.repository.dao.PolicyDAO;
import org.glite.authz.pap.repository.dao.filesystem.FileSystemRepositoryManager;
import org.glite.authz.pap.repository.exceptions.AlreadyExistsException;
import org.glite.authz.pap.repository.exceptions.InvalidVersionException;
import org.glite.authz.pap.repository.exceptions.NotFoundException;
import org.glite.authz.pap.repository.exceptions.RepositoryException;
import org.opensaml.xacml.policy.PolicyType;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemPolicyDAO
implements PolicyDAO {
    private static final Logger log = LoggerFactory.getLogger(FileSystemPolicyDAO.class);
    private static final Map<String, Map<String, PolicyTypeString>> cache = new ConcurrentHashMap<String, Map<String, PolicyTypeString>>();
    private static final PolicyHelper policyHelper = PolicyHelper.getInstance();
    private static FileSystemPolicyDAO instance = null;

    private FileSystemPolicyDAO() {
    }

    public static FileSystemPolicyDAO getInstance() {
        if (instance == null) {
            instance = new FileSystemPolicyDAO();
        }
        return instance;
    }

    private static String getPolicyFileAbsolutePath(String papId, String policyId) {
        return FileSystemRepositoryManager.getPAPDirAbsolutePath(papId) + FileSystemPolicyDAO.getPolicyFileName(policyId);
    }

    private static String getPolicyFileName(String policyId) {
        return "Policy_" + policyId + ".xml";
    }

    private static String getPolicyIdFromFileName(String fileName) {
        int start = "Policy_".length();
        int end = fileName.length() - ".xml".length();
        return fileName.substring(start, end);
    }

    private static String papDirNotFoundExceptionMsg(String papDirPAth) {
        return "Not found PAP directory: " + papDirPAth;
    }

    private static String policyExceptionMsg(String policyId) {
        return String.format("policyId=%s", policyId);
    }

    private static String policyNotFoundExceptionMsg(String policyId) {
        String msg = "Not found: " + FileSystemPolicyDAO.policyExceptionMsg(policyId);
        return msg;
    }

    @Override
    public synchronized void delete(String papId, String policyId) {
        Map<String, PolicyTypeString> papCache = cache.get(papId);
        if (papCache != null) {
            papCache.remove(policyId);
        }
        String policyFileName = FileSystemPolicyDAO.getPolicyFileAbsolutePath(papId, policyId);
        if (this.exists(papId, policyId)) {
            File policyFile = new File(policyFileName);
            if (papCache.size() == 0) {
                cache.remove(papId);
            }
            if (!policyFile.delete()) {
                throw new RepositoryException("Cannot delete file: " + policyFile.getAbsolutePath());
            }
        } else {
            throw new NotFoundException(FileSystemPolicyDAO.policyNotFoundExceptionMsg(policyId));
        }
    }

    @Override
    public synchronized void deleteAll(String papId) {
        String papDirAbsolutePath;
        File papDir;
        Map<String, PolicyTypeString> papCache = cache.get(papId);
        if (papCache != null) {
            papCache.clear();
            cache.remove(papId);
        }
        if (!(papDir = new File(papDirAbsolutePath = FileSystemRepositoryManager.getPAPDirAbsolutePath(papId))).exists()) {
            throw new NotFoundException(FileSystemPolicyDAO.papDirNotFoundExceptionMsg(papDirAbsolutePath));
        }
        for (File file : papDir.listFiles()) {
            String fileName;
            if (file.isDirectory() || !(fileName = file.getName()).startsWith("Policy_")) continue;
            file.delete();
        }
    }

    @Override
    public synchronized boolean exists(String papId, String policyId) {
        String policyFilePath = FileSystemPolicyDAO.getPolicyFileAbsolutePath(papId, policyId);
        File policyFile = new File(policyFilePath);
        return policyFile.exists();
    }

    @Override
    public synchronized List<PolicyType> getAll(String papId) {
        File papDir = new File(FileSystemRepositoryManager.getPAPDirAbsolutePath(papId));
        if (!papDir.exists()) {
            throw new NotFoundException(FileSystemPolicyDAO.papDirNotFoundExceptionMsg(papDir.getAbsolutePath()));
        }
        Map<String, PolicyTypeString> papCache = this.getPapCache(papId);
        LinkedList<PolicyType> policyList = new LinkedList<PolicyType>();
        for (File file : papDir.listFiles()) {
            String fileName;
            if (file.isDirectory() || !(fileName = file.getName()).startsWith("Policy_")) continue;
            String policyId = FileSystemPolicyDAO.getPolicyIdFromFileName(fileName);
            PolicyTypeString policy = papCache.get(policyId);
            if (policy == null) {
                try {
                    policy = new PolicyTypeString(policyId, policyHelper.readFromFileAsString(file));
                }
                catch (Throwable e) {
                    throw new RepositoryException(e);
                }
                papCache.put(policyId, policy);
            }
            policyList.add(new PolicyTypeString(policyId, policy.getPolicyString()));
            if (!policy.isDOMLoaded()) continue;
            log.warn("DOM not released for Policy id=" + policyId);
        }
        return policyList;
    }

    @Override
    public synchronized PolicyType getById(String papId, String policyId) {
        Map<String, PolicyTypeString> papCache = this.getPapCache(papId);
        PolicyTypeString policy = papCache.get(policyId);
        if (policy == null) {
            File policyFile = new File(FileSystemPolicyDAO.getPolicyFileAbsolutePath(papId, policyId));
            if (!policyFile.exists()) {
                if (papCache.size() == 0) {
                    cache.remove(papId);
                }
                throw new NotFoundException(FileSystemPolicyDAO.policyNotFoundExceptionMsg(policyId));
            }
            try {
                policy = new PolicyTypeString(policyId, policyHelper.readFromFileAsString(policyFile));
            }
            catch (Throwable e) {
                throw new RepositoryException(e);
            }
            papCache.put(policyId, policy);
        }
        if (policy.isDOMLoaded()) {
            log.warn("DOM not released for id=" + policyId);
        }
        return new PolicyTypeString(policyId, policy.getPolicyString());
    }

    @Override
    public synchronized void store(String papId, PolicyType policy) {
        PolicyTypeString policyTypeString = TypeStringUtils.cloneAsPolicyTypeString(policy);
        TypeStringUtils.releaseUnneededMemory(policy);
        File papDir = new File(FileSystemRepositoryManager.getPAPDirAbsolutePath(papId));
        if (!papDir.exists()) {
            throw new NotFoundException(FileSystemPolicyDAO.papDirNotFoundExceptionMsg(papDir.getAbsolutePath()));
        }
        String policyId = policyTypeString.getPolicyId();
        File policyFile = new File(FileSystemPolicyDAO.getPolicyFileAbsolutePath(papId, policyId));
        if (policyFile.exists()) {
            throw new AlreadyExistsException("Already exists: policyId=" + policyId);
        }
        PolicyHelper.toFile(policyFile, (XMLObject)policyTypeString);
        this.getPapCache(papId).put(policyId, policyTypeString);
        TypeStringUtils.releaseUnneededMemory(policyTypeString);
        log.debug("Stored policy: " + policyId);
    }

    @Override
    public synchronized void update(String papId, String version, PolicyType newPolicy) {
        PolicyTypeString newPolicyTypeString = TypeStringUtils.cloneAsPolicyTypeString(newPolicy);
        TypeStringUtils.releaseUnneededMemory(newPolicy);
        String policyId = newPolicyTypeString.getPolicyId();
        File policyFile = new File(FileSystemPolicyDAO.getPolicyFileAbsolutePath(papId, policyId));
        if (!policyFile.exists()) {
            throw new NotFoundException(FileSystemPolicyDAO.policyNotFoundExceptionMsg(policyId));
        }
        Map<String, PolicyTypeString> papCache = this.getPapCache(papId);
        PolicyTypeString oldPolicy = papCache.get(policyId);
        if (oldPolicy == null) {
            try {
                oldPolicy = new PolicyTypeString((PolicyType)policyHelper.buildFromFile(policyFile));
            }
            catch (Throwable e) {
                throw new RepositoryException(e);
            }
        }
        if (!oldPolicy.getVersion().equals(version)) {
            throw new InvalidVersionException(String.format("Attempting to update the wrong version of PolicyId=\"%s\" (requestedVersion=\"%s\", repositoryVersion=\"%s\")", policyId, version, oldPolicy.getVersion()));
        }
        TypeStringUtils.releaseUnneededMemory(oldPolicy);
        PolicyHelper.toFile(policyFile, (XMLObject)newPolicyTypeString);
        papCache.put(policyId, newPolicyTypeString);
        TypeStringUtils.releaseUnneededMemory(newPolicyTypeString);
    }

    private Map<String, PolicyTypeString> getPapCache(String papId) {
        Map<String, PolicyTypeString> papCache = cache.get(papId);
        if (papCache == null) {
            log.debug("New HashMap for papId=" + papId);
            papCache = new ConcurrentHashMap<String, PolicyTypeString>();
            cache.put(papId, papCache);
        }
        return papCache;
    }
}

