/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.repository.dao.filesystem;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.INIConfiguration;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.utils.Utils;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.repository.dao.PapDAO;
import org.glite.authz.pap.repository.dao.filesystem.FileSystemRepositoryManager;
import org.glite.authz.pap.repository.exceptions.AlreadyExistsException;
import org.glite.authz.pap.repository.exceptions.NotFoundException;
import org.glite.authz.pap.repository.exceptions.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemPapDAO
implements PapDAO {
    private static FileSystemPapDAO instance = null;
    private static String dbPath = FileSystemRepositoryManager.getFileSystemDatabaseDir();
    private static final Logger log = LoggerFactory.getLogger(FileSystemPapDAO.class);
    private static final String PAP_FILE_NAME = "pap_info.ini";
    private static final String PAPS_STANZA = "paps";
    private static final String VERSION_KEY = "general-info.version";
    private INIConfiguration iniConfiguration = new INIConfiguration();

    private FileSystemPapDAO() {
        File iniPAPConfigurationFile = new File(dbPath + File.separator + PAP_FILE_NAME);
        this.iniConfiguration.setFile(iniPAPConfigurationFile);
        try {
            if (!iniPAPConfigurationFile.exists()) {
                this.iniConfiguration.setProperty(VERSION_KEY, (Object)"1");
                this.iniConfiguration.save();
                this.iniConfiguration.clearProperty(VERSION_KEY);
            }
            this.iniConfiguration.load();
        }
        catch (ConfigurationException e) {
            throw new RepositoryException("Configuration error", e);
        }
    }

    public static FileSystemPapDAO getInstance() {
        if (instance == null) {
            instance = new FileSystemPapDAO();
        }
        return instance;
    }

    private static String aliasKey(String papAlias) {
        return "paps." + papAlias;
    }

    private static String dnKey(String papAlias) {
        return FileSystemPapDAO.aliasKey(papAlias) + "." + "dn";
    }

    private static String enabledKey(String papAlias) {
        return FileSystemPapDAO.aliasKey(papAlias) + "." + "enabled";
    }

    private static String hostnameKey(String papAlias) {
        return FileSystemPapDAO.aliasKey(papAlias) + "." + "hostname";
    }

    private static String idKey(String papAlias) {
        return FileSystemPapDAO.aliasKey(papAlias) + "." + "id";
    }

    private static String pathKey(String papAlias) {
        return FileSystemPapDAO.aliasKey(papAlias) + "." + "path";
    }

    private static String policyLastModificationTimeKey(String papAlias) {
        return FileSystemPapDAO.aliasKey(papAlias) + "." + "policyLastModificationTime";
    }

    private static String portKey(String papAlias) {
        return FileSystemPapDAO.aliasKey(papAlias) + "." + "port";
    }

    private static String protocolKey(String papAlias) {
        return FileSystemPapDAO.aliasKey(papAlias) + "." + "protocol";
    }

    private static String typeKey(String papAlias) {
        return FileSystemPapDAO.aliasKey(papAlias) + "." + "type";
    }

    private static String visibilityPublicKey(String papAlias) {
        return FileSystemPapDAO.aliasKey(papAlias) + "." + "public";
    }

    @Override
    public void delete(String papAlias) {
        if (!this.exists(papAlias)) {
            throw new NotFoundException(String.format("Not found: papAlias=%s", papAlias));
        }
        String papId = this.iniConfiguration.getString(FileSystemPapDAO.idKey(papAlias));
        PapContainer papContainer = new PapContainer(this.get(papAlias));
        papContainer.deleteAllPolicies();
        papContainer.deleteAllPolicySets();
        File papDir = new File(this.getPapDirAbsolutePath(papId));
        papDir.delete();
        this.removeFromINIConfiguration(papAlias);
    }

    @Override
    public boolean exists(String papAlias) {
        return this.existsInINIConfiguration(papAlias);
    }

    @Override
    public Pap get(String papAlias) {
        Pap pap = this.getPapFromINIConfiguration(papAlias);
        if (pap == null) {
            throw new NotFoundException(String.format("Not found: papAlias=%s", papAlias));
        }
        return pap;
    }

    @Override
    public List<String> getAliasList() {
        return new ArrayList<String>(Utils.getAliasSet(this.iniConfiguration, PAPS_STANZA));
    }

    @Override
    public List<Pap> getAll() {
        Set<String> aliases = Utils.getAliasSet(this.iniConfiguration, PAPS_STANZA);
        ArrayList<Pap> papList = new ArrayList<Pap>(aliases.size());
        for (String alias : aliases) {
            papList.add(this.getPapFromINIConfiguration(alias));
        }
        return papList;
    }

    @Override
    public String getVersion() {
        return this.iniConfiguration.getString(VERSION_KEY);
    }

    @Override
    public void store(Pap pap) {
        String papAlias = pap.getAlias();
        if (this.exists(papAlias)) {
            throw new AlreadyExistsException(String.format("Already exists: papAlias=%s", papAlias));
        }
        File directory = new File(this.getPapDirAbsolutePath(pap.getId()));
        if (!directory.mkdir()) {
            throw new RepositoryException(String.format("Cannot create directory for PAP: %s (id=%s) (dir=%s)", papAlias, pap.getId(), directory));
        }
        this.saveToINIConfiguration(pap);
    }

    @Override
    public void update(Pap pap) {
        String papAlias = pap.getAlias();
        if (!this.exists(papAlias)) {
            throw new NotFoundException(String.format("Not found: papAlias=%s", papAlias));
        }
        this.saveToINIConfiguration(pap);
    }

    private void clearPapProperties(String papAlias) {
        this.iniConfiguration.clearProperty(FileSystemPapDAO.dnKey(papAlias));
        this.iniConfiguration.clearProperty(FileSystemPapDAO.hostnameKey(papAlias));
        this.iniConfiguration.clearProperty(FileSystemPapDAO.enabledKey(papAlias));
        this.iniConfiguration.clearProperty(FileSystemPapDAO.portKey(papAlias));
        this.iniConfiguration.clearProperty(FileSystemPapDAO.pathKey(papAlias));
        this.iniConfiguration.clearProperty(FileSystemPapDAO.protocolKey(papAlias));
        this.iniConfiguration.clearProperty(FileSystemPapDAO.idKey(papAlias));
        this.iniConfiguration.clearProperty(FileSystemPapDAO.visibilityPublicKey(papAlias));
        this.iniConfiguration.clearProperty(FileSystemPapDAO.policyLastModificationTimeKey(papAlias));
        this.iniConfiguration.clearProperty(FileSystemPapDAO.typeKey(papAlias));
    }

    private boolean existsInINIConfiguration(String papAlias) {
        return this.keyExists(FileSystemPapDAO.idKey(papAlias));
    }

    private String getPapDirAbsolutePath(String papId) {
        return dbPath + File.separator + papId;
    }

    private Pap getPapFromINIConfiguration(String papAlias) {
        long policyLastModificationTime;
        if (papAlias == null) {
            return null;
        }
        if (!this.existsInINIConfiguration(papAlias)) {
            return null;
        }
        String type = this.iniConfiguration.getString(FileSystemPapDAO.typeKey(papAlias));
        String dn = this.iniConfiguration.getString(FileSystemPapDAO.dnKey(papAlias));
        String host = this.iniConfiguration.getString(FileSystemPapDAO.hostnameKey(papAlias));
        String port = this.iniConfiguration.getString(FileSystemPapDAO.portKey(papAlias));
        String protocol = this.iniConfiguration.getString(FileSystemPapDAO.protocolKey(papAlias));
        String path = this.iniConfiguration.getString(FileSystemPapDAO.pathKey(papAlias));
        String id = this.iniConfiguration.getString(FileSystemPapDAO.idKey(papAlias));
        boolean visibilityPublic = this.iniConfiguration.getBoolean(FileSystemPapDAO.visibilityPublicKey(papAlias));
        boolean enabled = this.iniConfiguration.getBoolean(FileSystemPapDAO.enabledKey(papAlias), false);
        Pap pap = new Pap(papAlias, Pap.isLocal(type), dn, host, port, path, protocol, visibilityPublic);
        pap.setId(id);
        pap.setEnabled(enabled);
        try {
            policyLastModificationTime = Long.parseLong(this.iniConfiguration.getString(FileSystemPapDAO.policyLastModificationTimeKey(papAlias)));
        }
        catch (NumberFormatException e) {
            policyLastModificationTime = 0L;
        }
        pap.setPolicyLastModificationTime(policyLastModificationTime);
        return pap;
    }

    private boolean keyExists(String key) {
        if (key == null) {
            return false;
        }
        String value = this.iniConfiguration.getString(key);
        if (value == null) {
            return false;
        }
        return value.length() != 0;
    }

    private void removeFromINIConfiguration(String papAlias) {
        this.clearPapProperties(papAlias);
        try {
            this.iniConfiguration.save();
        }
        catch (ConfigurationException e) {
            throw new RepositoryException(e);
        }
    }

    private void saveToINIConfiguration(Pap pap) throws RepositoryException {
        if (pap == null) {
            throw new RepositoryException("BUG: PAP is null");
        }
        this.clearPapProperties(pap.getAlias());
        this.setPapProperties(pap);
        try {
            this.iniConfiguration.save();
        }
        catch (ConfigurationException e) {
            throw new RepositoryException(e);
        }
    }

    private void setPapProperties(Pap pap) {
        String papAlias = pap.getAlias();
        this.iniConfiguration.setProperty(FileSystemPapDAO.typeKey(papAlias), (Object)pap.getTypeAsString());
        this.iniConfiguration.setProperty(FileSystemPapDAO.dnKey(papAlias), (Object)pap.getDn());
        this.iniConfiguration.setProperty(FileSystemPapDAO.hostnameKey(papAlias), (Object)pap.getHostname());
        this.iniConfiguration.setProperty(FileSystemPapDAO.portKey(papAlias), (Object)pap.getPort());
        this.iniConfiguration.setProperty(FileSystemPapDAO.pathKey(papAlias), (Object)pap.getPath());
        this.iniConfiguration.setProperty(FileSystemPapDAO.protocolKey(papAlias), (Object)pap.getProtocol());
        this.iniConfiguration.setProperty(FileSystemPapDAO.idKey(papAlias), (Object)pap.getId());
        this.iniConfiguration.setProperty(FileSystemPapDAO.visibilityPublicKey(papAlias), (Object)pap.isVisibilityPublic());
        this.iniConfiguration.setProperty(FileSystemPapDAO.enabledKey(papAlias), (Object)pap.isEnabled());
        this.iniConfiguration.setProperty(FileSystemPapDAO.policyLastModificationTimeKey(papAlias), (Object)pap.getPolicyLastModificationTimeInMilliseconds());
    }
}

