/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.repository;

import java.util.LinkedList;
import java.util.List;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.utils.PolicySetHelper;
import org.glite.authz.pap.common.xacml.wizard.PolicySetWizard;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.repository.exceptions.RepositoryException;
import org.opensaml.xacml.policy.PolicySetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryUtils {
    private static final Logger log = LoggerFactory.getLogger(RepositoryUtils.class);

    public static boolean checkForLoops(boolean repair) {
        boolean result = true;
        for (PapContainer papContainer : PapContainer.getContainers(PapManager.getInstance().getAllPaps())) {
            if (RepositoryUtils.checkForLoops(papContainer, papContainer.getRootPolicySet(), new LinkedList<String>(), repair)) continue;
            result = false;
        }
        return result;
    }

    public static boolean checkXMLValidation() {
        List<PapContainer> containerList = PapContainer.getContainers(PapManager.getInstance().getLocalPaps());
        for (PapContainer papContainer : containerList) {
            try {
                papContainer.getAllPolicySets();
                papContainer.getAllPolicies();
            }
            catch (RepositoryException e) {
                log.error("Repository checkXMLValidation() failed: " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    public static boolean checkXMLValidationInDetail(boolean repair) {
        boolean result = true;
        for (PapContainer papContainer : PapContainer.getContainers(PapManager.getInstance().getLocalPaps())) {
            PolicySetType rootPS;
            try {
                rootPS = papContainer.getRootPolicySet();
            }
            catch (RepositoryException e) {
                String rootAlias = papContainer.getPap().getAlias();
                String action = String.format("remove all policies and and policy sets for root policy set %s", rootAlias);
                log.error(String.format("The root policy set %s (id=%s) is corrupted. Suggested action: %s", rootAlias, action));
                if (repair) {
                    log.info("Automatic repair is set. Action: " + action);
                    papContainer.deleteAllPolicies();
                    papContainer.deleteAllPolicySets();
                    papContainer.createRootPolicySet();
                    log.info("Automatic repair successfully completed (deleted root policy set " + rootAlias + ")");
                    continue;
                }
                result = false;
                continue;
            }
            for (String policySetId : PolicySetHelper.getPolicySetIdReferencesValues(rootPS)) {
                PolicySetType policySet;
                try {
                    policySet = papContainer.getPolicySet(policySetId);
                }
                catch (RepositoryException e) {
                    String action = String.format("remove policy set %s", policySetId);
                    log.error(String.format("The policy set \"%s\" is corrupted. Suggested action: %s", policySetId, action));
                    if (repair) {
                        log.info("Automatic repair is set. Action: " + action);
                        PolicySetHelper.deletePolicySetReference(rootPS, policySetId);
                        String version = rootPS.getVersion();
                        PolicySetWizard.increaseVersion(rootPS);
                        papContainer.updatePolicySet(version, rootPS);
                        papContainer.deletePolicySet(policySetId);
                        log.info("Automatic repair successfully completed (deleted policy set " + policySetId + ")");
                        continue;
                    }
                    result = false;
                    continue;
                }
                for (String policyId : PolicySetHelper.getPolicyIdReferencesValues(policySet)) {
                    try {
                        papContainer.getPolicy(policyId);
                    }
                    catch (RepositoryException e) {
                        String action = String.format("remove policy %s", policyId);
                        log.error(String.format("The policy \"%s\" is corrupted. Suggested action: %s", policyId, action));
                        if (repair) {
                            log.info("Automatic repair is set. Action: " + action);
                            PolicySetHelper.deletePolicyReference(policySet, policyId);
                            String version = policySet.getVersion();
                            PolicySetWizard.increaseVersion(policySet);
                            papContainer.updatePolicySet(version, policySet);
                            papContainer.deletePolicy(policyId);
                            log.info("Automatic repair successfully completed (deleted policy " + policyId + ")");
                            continue;
                        }
                        result = false;
                    }
                }
            }
        }
        return result;
    }

    public static boolean performAllChecks(boolean repair) {
        boolean success = true;
        if (!RepositoryUtils.checkXMLValidation()) {
            log.info("Starting detailed check for XML validation");
            success = RepositoryUtils.checkXMLValidationInDetail(repair);
        }
        if (success) {
            log.info("Starting check for loops");
            success = RepositoryUtils.checkForLoops(repair);
        }
        if (success) {
            log.info("Starting purge of unreferenced objects");
            RepositoryUtils.purgeUnreferencedPolicySets();
            RepositoryUtils.purgeUnreferencedPolicies();
        }
        return success;
    }

    public static void purgeUnreferencedPolicies() {
        for (PapContainer papContainer : PapContainer.getContainers(PapManager.getInstance().getLocalPaps())) {
            papContainer.purgeUnreferencesPolicies();
        }
    }

    public static void purgeUnreferencedPolicySets() {
        for (PapContainer papContainer : PapContainer.getContainers(PapManager.getInstance().getLocalPaps())) {
            papContainer.purgeUnreferencedPolicySets();
        }
    }

    private static boolean checkForLoops(PapContainer papContainer, PolicySetType policySet, List<String> forbiddenIdList, boolean repair) {
        boolean result = true;
        String policySetId = policySet.getPolicySetId();
        forbiddenIdList.add(policySetId);
        for (String id : forbiddenIdList) {
            if (!PolicySetHelper.hasPolicySetReferenceId(policySet, id)) continue;
            String action = String.format("remove reference to policy set %s inside policy set %s", id, policySetId);
            log.error(String.format("The policy set \"%s\" contains a loop. Suggested action: %s", policySetId, action));
            if (repair) {
                log.info("Automatic repair is set. Action: " + action);
                PolicySetHelper.deletePolicySetReference(policySet, id);
                String version = policySet.getVersion();
                PolicySetWizard.increaseVersion(policySet);
                papContainer.updatePolicySet(version, policySet);
                log.info("Automatic repair successfully completed for policy set " + policySetId);
                continue;
            }
            result = false;
        }
        List<String> policySetIdList = PolicySetHelper.getPolicySetIdReferencesValues(policySet);
        TypeStringUtils.releaseUnneededMemory(policySet);
        for (String id : policySetIdList) {
            LinkedList<String> newForbiddenList = new LinkedList<String>();
            for (String s : forbiddenIdList) {
                newForbiddenList.add(s);
            }
            result = result && RepositoryUtils.checkForLoops(papContainer, papContainer.getPolicySet(id), newForbiddenList, repair);
        }
        return result;
    }
}

