/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.repository;

import org.glite.authz.pap.repository.dao.filesystem.FileSystemRepositoryManager;
import org.glite.authz.pap.repository.exceptions.InvalidVersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepositoryManager {
    public static final String REPOSITORY_MANAGER_VERSION = "1";
    private static final Logger log = LoggerFactory.getLogger(RepositoryManager.class);
    private static boolean initialized = false;

    protected RepositoryManager() {
    }

    public static void bootstrap() {
        FileSystemRepositoryManager.getInstance().initialize();
        RepositoryManager.checkVersion();
        initialized = true;
    }

    private static void checkVersion() {
        String repositoryVersion = FileSystemRepositoryManager.getInstance().getRepositoryVersion();
        if (!REPOSITORY_MANAGER_VERSION.equals(repositoryVersion)) {
            throw new InvalidVersionException("Invalid repository version (v" + repositoryVersion + "). Requested version is v" + REPOSITORY_MANAGER_VERSION);
        }
        log.info("Repository version: v" + repositoryVersion);
    }

    protected abstract String getRepositoryVersion();

    protected abstract void initialize();
}

