/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.monitoring;

import java.util.TreeMap;
import org.glite.authz.pap.common.PAPConfiguration;
import org.glite.authz.pap.common.Version;

public class MonitoredProperties {
    public static final String NUM_OF_POLICIES_PROP_NAME = "NumberOfPolicies";
    public static final String NUM_OF_LOCAL_POLICIES_PROP_NAME = "NumberOfLocalPolicies";
    public static final String NUM_OF_REMOTE_POLICIES_PROP_NAME = "NumberOfRemotePolicies";
    public static final String POLICY_LAST_MODIFICATION_TIME_PROP_NAME = "PolicyLastModificationTime";
    public static final String POLICY_LAST_MODIFICATION_TIME_MILLIS_PROP_NAME = "PolicyLastModificationTimeMillis";
    public static final String SERVICE_STARTUP_TIME_PROP_NAME = "ServiceStartupTime";
    public static final String SERVICE_STARTUP_TIME_MILLIS_PROP_NAME = "ServiceStartupTimeMillis";
    public static final String STATUS_PROP_NAME = "Status";
    public static final String USED_MEMORY_PROP_NAME = "UsedMemory";
    public static final String MAX_MEMORY_PROP_NAME = "MaxMemory";
    public static final String SERVICE_VERSION_PROP_NAME = "ServiceVersion";
    public static final String SERVICE_NAME_PROP_NAME = "Service";
    private static final String[] propertyOrdering = new String[]{"Status", "Service", "ServiceVersion", "ServiceStartupTime", "ServiceStartupTimeMillis", "MaxMemory", "UsedMemory", "PolicyLastModificationTime", "PolicyLastModificationTimeMillis", "NumberOfPolicies", "NumberOfLocalPolicies", "NumberOfRemotePolicies"};
    TreeMap<String, String> props = new TreeMap();

    private MonitoredProperties() {
        PAPConfiguration conf = PAPConfiguration.instance();
        this.props.put(STATUS_PROP_NAME, "OK");
        this.props.put(SERVICE_NAME_PROP_NAME, "Argus PAP");
        this.props.put(SERVICE_VERSION_PROP_NAME, Version.getServiceVersion());
        this.props.put(SERVICE_STARTUP_TIME_PROP_NAME, conf.getMonitoringProperty(SERVICE_STARTUP_TIME_PROP_NAME).toString());
        this.props.put(SERVICE_STARTUP_TIME_MILLIS_PROP_NAME, conf.getMonitoringProperty(SERVICE_STARTUP_TIME_MILLIS_PROP_NAME).toString());
        this.props.put(NUM_OF_POLICIES_PROP_NAME, conf.getMonitoringProperty(NUM_OF_POLICIES_PROP_NAME).toString());
        this.props.put(NUM_OF_LOCAL_POLICIES_PROP_NAME, conf.getMonitoringProperty(NUM_OF_LOCAL_POLICIES_PROP_NAME).toString());
        this.props.put(NUM_OF_REMOTE_POLICIES_PROP_NAME, conf.getMonitoringProperty(NUM_OF_REMOTE_POLICIES_PROP_NAME).toString());
        this.props.put(POLICY_LAST_MODIFICATION_TIME_PROP_NAME, conf.getMonitoringProperty(POLICY_LAST_MODIFICATION_TIME_PROP_NAME).toString());
        this.props.put(POLICY_LAST_MODIFICATION_TIME_MILLIS_PROP_NAME, conf.getMonitoringProperty(POLICY_LAST_MODIFICATION_TIME_MILLIS_PROP_NAME).toString());
        Runtime r = Runtime.getRuntime();
        this.props.put(USED_MEMORY_PROP_NAME, "" + r.totalMemory() + " bytes");
        this.props.put(MAX_MEMORY_PROP_NAME, "" + r.maxMemory() + " bytes");
    }

    public static MonitoredProperties instance() {
        return new MonitoredProperties();
    }

    private String propertyString(String propName) {
        return propName + ": " + this.props.get(propName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String s : propertyOrdering) {
            builder.append(this.propertyString(s) + "\n");
        }
        return builder.toString();
    }
}

