/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.distribution;

import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.glite.authz.pap.client.ServiceClient;
import org.glite.authz.pap.client.ServiceClientFactory;
import org.glite.authz.pap.common.xacml.impl.PolicySetTypeString;
import org.glite.authz.pap.common.xacml.impl.PolicyTypeString;
import org.glite.authz.pap.services.provisioning.axis_skeletons.Provisioning;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.common.impl.ExtensionsBuilder;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Statement;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.xacml.XACMLObject;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.opensaml.xacml.profile.saml.XACMLPolicyQueryType;
import org.opensaml.xacml.profile.saml.XACMLPolicyStatementType;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAPClient {
    private static final Logger log = LoggerFactory.getLogger(PAPClient.class);
    private final Provisioning provisioningClient;
    private final String url;
    private XACMLPolicyQueryType xacmlPolicyQuery;

    public PAPClient(String url) {
        ServiceClientFactory serviceClientFactory = ServiceClientFactory.getServiceClientFactory();
        ServiceClient serviceClient = serviceClientFactory.createServiceClient();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        this.url = url + serviceClient.getProvisioningServiceName();
        this.provisioningClient = serviceClient.getProvisioningService(this.url);
        this.xacmlPolicyQuery = PAPClient.makeStandardPAPQuery();
    }

    private static XACMLPolicyQueryType makeStandardPAPQuery() {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        XACMLPolicyQueryType xacmlPolicyQuery = (XACMLPolicyQueryType)builderFactory.getBuilder(XACMLPolicyQueryType.TYPE_NAME_XACML20).buildObject(XACMLPolicyQueryType.DEFAULT_ELEMENT_NAME_XACML20.getNamespaceURI(), XACMLPolicyQueryType.DEFAULT_ELEMENT_NAME_XACML20.getLocalPart(), XACMLPolicyQueryType.DEFAULT_ELEMENT_NAME_XACML20.getPrefix());
        IssuerBuilder issuerBuilder = (IssuerBuilder)builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = issuerBuilder.buildObject();
        issuer.setValue("ISSUER_STRING");
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        xacmlPolicyQuery.setIssuer(issuer);
        xacmlPolicyQuery.setIssueInstant(new DateTime());
        xacmlPolicyQuery.setVersion(SAMLVersion.VERSION_20);
        xacmlPolicyQuery.setID("_12345");
        xacmlPolicyQuery.setIssueInstant(new DateTime());
        ExtensionsBuilder eBuilder = (ExtensionsBuilder)builderFactory.getBuilder(new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Extensions", "md"));
        Extensions extensions = eBuilder.buildObject();
        xacmlPolicyQuery.setExtensions(extensions);
        return xacmlPolicyQuery;
    }

    public List<XACMLObject> retrievePolicies() throws RemoteException, ServiceException {
        log.info("Requesting policies to remote PAP endpoint: " + this.url);
        Response response = this.provisioningClient.XACMLPolicyQuery(this.xacmlPolicyQuery);
        List<XACMLObject> resultList = this.getXACMLObjectList(response);
        return resultList;
    }

    private List<XACMLObject> getXACMLObjectList(Response response) {
        LinkedList<XACMLObject> responseList = new LinkedList<XACMLObject>();
        for (Assertion assertion : response.getAssertions()) {
            for (Statement statement : assertion.getStatements()) {
                String statementLocalName = statement.getSchemaType().getLocalPart();
                if (!"XACMLPolicyStatementType".equals(statementLocalName)) continue;
                XACMLPolicyStatementType policyStatement = (XACMLPolicyStatementType)statement;
                for (PolicySetType policySet : policyStatement.getPolicySets()) {
                    responseList.add((XACMLObject)new PolicySetTypeString(policySet));
                }
                for (PolicyType policy : policyStatement.getPolicies()) {
                    responseList.add((XACMLObject)new PolicyTypeString(policy));
                }
            }
        }
        return responseList;
    }
}

