/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common.xacml.wizard;

import java.util.ArrayList;
import java.util.List;
import org.glite.authz.pap.common.utils.Utils;
import org.glite.authz.pap.common.xacml.utils.RuleHelper;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizard;
import org.glite.authz.pap.common.xacml.wizard.TargetWizard;
import org.glite.authz.pap.common.xacml.wizard.WizardUtils;
import org.glite.authz.pap.common.xacml.wizard.exceptions.WizardException;
import org.opensaml.xacml.policy.EffectType;
import org.opensaml.xacml.policy.RuleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleWizard {
    private EffectType effect = null;
    private RuleType rule;
    private String ruleId = null;
    private final TargetWizard targetWizard;

    public RuleWizard(AttributeWizard attributeWizard, EffectType effect) {
        this(RuleWizard.getList(attributeWizard), effect);
    }

    public RuleWizard(EffectType effect) {
        this(RuleWizard.getList(null), effect);
    }

    public RuleWizard(List<AttributeWizard> targetAttributeWizardList, EffectType effect) {
        if (targetAttributeWizardList == null) {
            targetAttributeWizardList = new ArrayList<AttributeWizard>(0);
        }
        this.targetWizard = new TargetWizard(targetAttributeWizardList);
        this.effect = effect;
        this.ruleId = WizardUtils.generateId(null);
    }

    public RuleWizard(RuleType rule) {
        if (rule == null) {
            throw new WizardException("Invalid argument: RuleType is null.");
        }
        this.rule = rule;
        this.ruleId = rule.getRuleId();
        this.effect = rule.getEffect();
        this.targetWizard = new TargetWizard(rule.getTarget());
    }

    private static List<AttributeWizard> getList(AttributeWizard attributeWizard) {
        if (attributeWizard == null) {
            return new ArrayList<AttributeWizard>(0);
        }
        ArrayList<AttributeWizard> list = new ArrayList<AttributeWizard>(1);
        list.add(attributeWizard);
        return list;
    }

    public boolean deniesAttribute(AttributeWizard attributeWizard) {
        if (!EffectType.Deny.equals((Object)this.rule.getEffect())) {
            return false;
        }
        for (AttributeWizard targetAttributeWizard : this.targetWizard.getAttributeWizardList()) {
            if (!targetAttributeWizard.equals(attributeWizard)) continue;
            return true;
        }
        return false;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public RuleType getXACML() {
        this.initRuleTypeIfNotSet();
        return this.rule;
    }

    public boolean isEquivalent(RuleType rule) {
        if (this.effect != rule.getEffect()) {
            return false;
        }
        if (rule.getCondition() != null) {
            return false;
        }
        return this.targetWizard.isEquivalent(rule.getTarget());
    }

    public void releaseChildrenDOM() {
        this.targetWizard.releaseChildrenDOM();
        this.targetWizard.releaseDOM();
        if (this.rule != null) {
            this.rule.releaseChildrenDOM(true);
        }
    }

    public void releaseDOM() {
        if (this.rule != null) {
            this.rule.releaseDOM();
            this.rule = null;
        }
    }

    public String toFormattedString(boolean printIds) {
        return this.toFormattedString(0, 4, printIds);
    }

    public String toFormattedString(int baseIndentation, int internalIndentation, boolean printIds) {
        String baseIndentString = Utils.fillWithSpaces(baseIndentation);
        String indentString = Utils.fillWithSpaces(baseIndentation + internalIndentation);
        StringBuffer sb = new StringBuffer();
        String effectString = this.effect.toString().toLowerCase();
        if (printIds) {
            sb.append(String.format("%sid=%s\n", baseIndentString, this.ruleId));
        }
        boolean multipleLines = this.targetWizard.getAttributeWizardList().size() > 1;
        sb.append(String.format("%srule %s { ", baseIndentString, effectString));
        if (multipleLines) {
            sb.append('\n');
        }
        for (AttributeWizard attributeWizard : this.targetWizard.getAttributeWizardList()) {
            if (multipleLines) {
                sb.append(indentString);
            }
            sb.append(String.format("%s ", attributeWizard.toFormattedString()));
            if (!multipleLines) continue;
            sb.append('\n');
        }
        if (multipleLines) {
            sb.append(baseIndentString);
        }
        sb.append("}");
        return sb.toString();
    }

    private void initRuleTypeIfNotSet() {
        if (this.rule == null) {
            this.setRuleType();
        }
    }

    private void setRuleType() {
        this.releaseDOM();
        this.rule = RuleHelper.build(this.ruleId, this.effect);
        this.rule.setTarget(this.targetWizard.getXACML());
    }
}

