/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common.xacml.wizard;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.glite.authz.pap.common.utils.Utils;
import org.glite.authz.pap.common.xacml.impl.PolicySetTypeString;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.utils.DescriptionTypeHelper;
import org.glite.authz.pap.common.xacml.utils.ObligationsHelper;
import org.glite.authz.pap.common.xacml.utils.PolicySetHelper;
import org.glite.authz.pap.common.xacml.utils.XMLObjectHelper;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizard;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizardType;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizardTypeConfiguration;
import org.glite.authz.pap.common.xacml.wizard.ObligationWizard;
import org.glite.authz.pap.common.xacml.wizard.PolicyWizard;
import org.glite.authz.pap.common.xacml.wizard.TargetWizard;
import org.glite.authz.pap.common.xacml.wizard.WizardUtils;
import org.glite.authz.pap.common.xacml.wizard.XACMLWizard;
import org.glite.authz.pap.common.xacml.wizard.exceptions.PolicySetWizardException;
import org.glite.authz.pap.common.xacml.wizard.exceptions.UnsupportedPolicyException;
import org.glite.authz.pap.common.xacml.wizard.exceptions.UnsupportedPolicySetWizardException;
import org.opensaml.xacml.policy.ObligationType;
import org.opensaml.xacml.policy.ObligationsType;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetWizard
extends XACMLWizard {
    private static final Logger log = LoggerFactory.getLogger(PolicySetWizard.class);
    protected static final AttributeWizardType attributeWizardType = AttributeWizardTypeConfiguration.getInstance().getResourceAttributeWizard();
    protected String description = null;
    protected final List<ObligationWizard> obligationWizardList = new LinkedList<ObligationWizard>();
    protected PolicySetType policySet = null;
    protected String policySetId = null;
    protected final List<PolicySetWizard> policySetWizardList;
    protected final List<PolicyWizard> policyWizardList;
    protected final String resourceValue;
    protected final TargetWizard targetWizard;
    protected String version = null;

    public PolicySetWizard(AttributeWizard attributeWizard) {
        if (attributeWizard.getAttributeWizardType() != attributeWizardType) {
            throw new UnsupportedPolicySetWizardException("Attribute not supported: " + attributeWizard.getId());
        }
        this.resourceValue = attributeWizard.getValue();
        this.policySetId = WizardUtils.generateId(null);
        this.version = "1";
        this.targetWizard = new TargetWizard(attributeWizard);
        this.policyWizardList = new LinkedList<PolicyWizard>();
        this.policySetWizardList = new LinkedList<PolicySetWizard>();
    }

    public PolicySetWizard(PolicySetType policySet, List<PolicyWizard> policyWizardList, PolicySetType[] childPolicySetList) {
        boolean found;
        this.policySet = policySet;
        this.policySetId = policySet.getPolicySetId();
        if (policySet.getDescription() != null) {
            this.description = policySet.getDescription().getValue();
        }
        this.targetWizard = new TargetWizard(policySet.getTarget());
        PolicySetWizard.validateTargetAttributewizardList(this.targetWizard.getAttributeWizardList());
        this.resourceValue = this.targetWizard.getAttributeWizardList().get(0).getValue();
        try {
            this.version = policySet.getVersion();
            new Integer(this.version);
        }
        catch (NumberFormatException e) {
            throw new UnsupportedPolicyException(String.format("Wrong version format (policySetId=\"%s\")", policySet.getPolicySetId()), e);
        }
        if (policySet.getObligations() != null) {
            List obligationList = policySet.getObligations().getObligations();
            for (ObligationType obligation : obligationList) {
                this.obligationWizardList.add(new ObligationWizard(obligation));
            }
        }
        this.policyWizardList = new LinkedList<PolicyWizard>();
        this.policySetWizardList = new LinkedList<PolicySetWizard>();
        List<String> idReferenceList = PolicySetHelper.getPolicyIdReferencesValues(policySet);
        if (idReferenceList.size() > 0 && policyWizardList == null) {
            throw new PolicySetWizardException("policyList is null");
        }
        for (String policyIdReference : idReferenceList) {
            found = false;
            for (PolicyWizard policyWizard : policyWizardList) {
                if (!policyIdReference.equals(policyWizard.getPolicyId())) continue;
                this.policyWizardList.add(policyWizard);
                found = true;
            }
            if (found) continue;
            PolicySetHelper.deletePolicyReference(policySet, policyIdReference);
            log.warn("Not found policy reference: " + policyIdReference);
        }
        idReferenceList = PolicySetHelper.getPolicySetIdReferencesValues(policySet);
        if (idReferenceList.size() > 0 && childPolicySetList == null) {
            throw new PolicySetWizardException("childPolicySetList is null");
        }
        for (String policySetIdReference : idReferenceList) {
            found = false;
            for (PolicySetType childPolicySet : childPolicySetList) {
                if (!policySetIdReference.equals(childPolicySet.getPolicySetId())) continue;
                PolicySetWizard psw = new PolicySetWizard(childPolicySet, policyWizardList, childPolicySetList);
                this.policySetWizardList.add(psw);
                TypeStringUtils.releaseUnneededMemory(psw);
                TypeStringUtils.releaseUnneededMemory(childPolicySet);
                found = true;
            }
            if (found) continue;
            PolicySetHelper.deletePolicySetReference(policySet, policySetIdReference);
            log.warn("Not found policy set reference: " + policySetIdReference);
        }
    }

    public static String getResourceValue(PolicySetType policySet) {
        TargetWizard targetWizard = new TargetWizard(policySet.getTarget());
        try {
            PolicySetWizard.validateTargetAttributewizardList(targetWizard.getAttributeWizardList());
        }
        catch (UnsupportedPolicySetWizardException e) {
            return null;
        }
        return targetWizard.getAttributeWizardList().get(0).getValue();
    }

    public static void increaseVersion(PolicySetType policySet) {
        int version;
        try {
            version = new Integer(policySet.getVersion());
            ++version;
        }
        catch (NumberFormatException e) {
            log.error("Unrecognized version format, setting version to 1. PolicySetId=" + policySet.getPolicySetId());
            version = 1;
        }
        policySet.setVersion(Integer.toString(version));
    }

    private static void validateTargetAttributewizardList(List<AttributeWizard> targetAttributeWizardList) {
        if (targetAttributeWizardList.size() != 1) {
            throw new UnsupportedPolicySetWizardException("Wrong number of attributes, only one is supported");
        }
        AttributeWizard aw = targetAttributeWizardList.get(0);
        if (aw.getAttributeWizardType() != attributeWizardType) {
            throw new UnsupportedPolicySetWizardException("Only resource attributes are supported");
        }
    }

    public void addObligation(ObligationWizard obligationWizard) {
        this.obligationWizardList.add(obligationWizard);
        this.invalidatePolicySetType();
    }

    public void addPolicy(PolicyWizard policyWizard) {
        this.policyWizardList.add(policyWizard);
        this.invalidatePolicySetType();
    }

    public void addPolicySet(PolicySetWizard policySetWizard) {
        this.policySetWizardList.add(policySetWizard);
        this.invalidatePolicySetType();
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getPolicyIdReferences() {
        ArrayList<String> idRefList = new ArrayList<String>(this.policyWizardList.size());
        for (PolicyWizard policyWizard : this.policyWizardList) {
            idRefList.add(policyWizard.getPolicyId());
        }
        return idRefList;
    }

    public String getPolicySetId() {
        return this.policySetId;
    }

    public List<String> getPolicySetIdReferences() {
        ArrayList<String> idRefList = new ArrayList<String>(this.policySetWizardList.size());
        for (PolicySetWizard policySetWizard : this.policySetWizardList) {
            idRefList.add(policySetWizard.getPolicySetId());
        }
        return idRefList;
    }

    public List<PolicyWizard> getPolicyWizardList() {
        return this.policyWizardList;
    }

    public String getTagAndValue() {
        return String.format("%s \"%s\"", attributeWizardType.getId(), this.resourceValue);
    }

    public TargetWizard getTargetWizard() {
        return this.targetWizard;
    }

    public int getVersion() {
        return Integer.valueOf(this.version);
    }

    public String getVersionString() {
        return this.version;
    }

    public PolicySetType getXACML() {
        this.initPolicySetTypeIfNotSet();
        return this.policySet;
    }

    public PolicySetType getXACMLNoReferences() {
        return this.buildXACMLNoReferences();
    }

    public void increaseVersion() {
        this.setVersion(this.getVersion() + 1);
    }

    public void releaseChildrenDOM() {
        this.targetWizard.releaseChildrenDOM();
        this.targetWizard.releaseDOM();
        for (ObligationWizard obligationWizard : this.obligationWizardList) {
            obligationWizard.releaseChildrenDOM();
            obligationWizard.releaseDOM();
        }
        for (PolicyWizard policyWizard : this.policyWizardList) {
            policyWizard.releaseChildrenDOM();
            policyWizard.releaseDOM();
        }
        for (PolicySetWizard policySetWizard : this.policySetWizardList) {
            policySetWizard.releaseChildrenDOM();
            policySetWizard.releaseDOM();
        }
    }

    public void releaseDOM() {
        if (this.policySet != null) {
            this.policySet.releaseDOM();
            this.policySet = null;
        }
    }

    public void setDescription(String value) {
        this.description = value;
        if (this.policySet != null) {
            this.policySet.setDescription(DescriptionTypeHelper.build(value));
        }
    }

    public void setPolicySetId(String id) {
        this.policySetId = id;
        if (this.policySet != null) {
            this.policySet.setPolicySetId(id);
        }
    }

    public void setVersion(int version) {
        this.version = Integer.toString(version);
        if (this.policySet != null) {
            this.policySet.setVersion(this.version);
        }
    }

    public boolean targetEquals(PolicySetWizard policySetWizard) {
        return this.targetWizard.equals(policySetWizard.getTargetWizard());
    }

    public String toFormattedString(boolean printIds) {
        return this.toFormattedString(0, 4, printIds, false);
    }

    public String toFormattedString(boolean printIds, boolean printRulesId) {
        return this.toFormattedString(0, 4, printIds, printRulesId);
    }

    public String toFormattedString(int baseIndentation, int internalIndentation, boolean printIds, boolean printRulesId) {
        String baseIndentString = Utils.fillWithSpaces(baseIndentation);
        String indentString = Utils.fillWithSpaces(baseIndentation + internalIndentation);
        StringBuffer sb = new StringBuffer();
        if (printIds) {
            sb.append(String.format("%sid=%s\n", baseIndentString, this.policySetId));
        }
        sb.append(String.format("%sresource \"%s\" {\n", baseIndentString, this.resourceValue));
        if (this.description != null) {
            sb.append(String.format("%sdescription=\"%s\"\n", indentString, this.description));
        }
        for (ObligationWizard obligationWizard : this.obligationWizardList) {
            sb.append(obligationWizard.toFormattedString(baseIndentation + internalIndentation, internalIndentation));
            sb.append('\n');
        }
        for (PolicyWizard policyWizard : this.policyWizardList) {
            sb.append('\n');
            sb.append(policyWizard.toFormattedString(baseIndentation + internalIndentation, internalIndentation, printIds, printRulesId));
            sb.append('\n');
        }
        sb.append(baseIndentString + "}");
        return sb.toString();
    }

    public String toXACMLString() {
        this.initPolicySetTypeIfNotSet();
        StringBuffer sb = new StringBuffer();
        sb.append(XMLObjectHelper.toString((XMLObject)this.policySet));
        sb.append('\n');
        for (PolicySetWizard policySetWizard : this.policySetWizardList) {
            sb.append(policySetWizard.toXACMLString());
            sb.append('\n');
        }
        for (PolicyWizard policyWizard : this.policyWizardList) {
            sb.append(policyWizard.toXACMLString());
            sb.append('\n');
        }
        return sb.toString();
    }

    private PolicySetTypeString buildXACMLNoReferences() {
        PolicySetTypeString policySet = new PolicySetTypeString(PolicySetHelper.build(this.policySetId, "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:first-applicable", this.targetWizard.getXACML(), null));
        if (this.description != null) {
            policySet.setDescription(DescriptionTypeHelper.build(this.description));
        }
        policySet.setVersion(this.version);
        return policySet;
    }

    private void initPolicySetTypeIfNotSet() {
        if (this.policySet == null) {
            this.setPolicySetType(true);
        }
    }

    private void invalidatePolicySetType() {
        this.releaseChildrenDOM();
        this.releaseDOM();
    }

    private void setPolicySetType(boolean includeReferences) {
        this.releaseDOM();
        this.policySet = this.buildXACMLNoReferences();
        if (this.obligationWizardList.size() > 0) {
            ObligationsType obligations = ObligationsHelper.build();
            List obligationList = obligations.getObligations();
            for (ObligationWizard obligationWizard : this.obligationWizardList) {
                obligationList.add(obligationWizard.getXACML());
            }
            this.policySet.setObligations(obligations);
        }
        if (includeReferences) {
            for (PolicySetWizard policySetWizard : this.policySetWizardList) {
                PolicySetHelper.addPolicySetReference(this.policySet, policySetWizard.getPolicySetId());
            }
            for (PolicyWizard policyWizard : this.policyWizardList) {
                PolicySetHelper.addPolicyReference(this.policySet, policyWizard.getPolicyId());
            }
        }
    }
}

