/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common.xacml.wizard;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizardType;
import org.glite.authz.pap.common.xacml.wizard.exceptions.AttributeWizardTypeConfigurationException;
import org.glite.authz.pap.common.xacml.wizard.exceptions.UnsupportedAttributeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeWizardTypeConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AttributeWizardTypeConfiguration.class);
    private static AttributeWizardType actionPolicyAttributeWizard = null;
    private static AttributeWizardType resourcePolicySetAttributeWizard = null;
    private static final String UNRECOGNIZED_ATTRIBUTE_ID = "unrecognized-id";
    private static AttributeWizardTypeConfiguration instance = null;
    private static List<AttributeWizardType> list = null;

    private static String baseKey(String id) {
        return id;
    }

    public static void bootstrap(String attributeMappingsFileName) {
        list = new LinkedList<AttributeWizardType>();
        AttributeWizardTypeConfiguration.initListFromFile(attributeMappingsFileName);
        AttributeWizardTypeConfiguration.initResourcePolicySetAttributeWizard();
        AttributeWizardTypeConfiguration.initActionPolicyAttributeWizard();
    }

    private static boolean checkIdExist(String id) {
        for (AttributeWizardType attributeWizardType : list) {
            if (!attributeWizardType.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkXacmlIdExist(String xacmlId) {
        for (AttributeWizardType attributeWizardType : list) {
            if (!attributeWizardType.getXacmlId().equals(xacmlId)) continue;
            return true;
        }
        return false;
    }

    public static AttributeWizardTypeConfiguration getInstance() {
        if (list == null) {
            throw new AttributeWizardTypeConfigurationException("Initialization is required (call bootstrap()) before calling the getInstance method");
        }
        if (instance == null) {
            instance = new AttributeWizardTypeConfiguration();
        }
        return instance;
    }

    private static String idKey() {
        return "id";
    }

    private static void initActionPolicyAttributeWizard() {
        for (AttributeWizardType attributeWizardType : list) {
            if (!"action".equals(attributeWizardType.getId())) continue;
            actionPolicyAttributeWizard = attributeWizardType;
            return;
        }
        throw new AttributeWizardTypeConfigurationException("Cannot find id \"action\"");
    }

    private static void initListFromFile(String fileName) {
        String[] idArray;
        PropertiesConfiguration configuration;
        File attributeMappingsFile = new File(fileName);
        if (!attributeMappingsFile.exists()) {
            throw new AttributeWizardTypeConfigurationException("Configuration file not found: " + attributeMappingsFile.getAbsolutePath());
        }
        try {
            configuration = new PropertiesConfiguration(attributeMappingsFile);
        }
        catch (ConfigurationException e) {
            throw new AttributeWizardTypeConfigurationException("Error reading configuration: " + attributeMappingsFile.getAbsolutePath());
        }
        for (String id : idArray = configuration.getStringArray(AttributeWizardTypeConfiguration.idKey())) {
            AttributeWizardType.TargetElement targetElement;
            if (AttributeWizardTypeConfiguration.checkIdExist(id)) {
                throw new AttributeWizardTypeConfigurationException("Error: duplicated id \"" + id + "\" (" + attributeMappingsFile.getAbsolutePath() + ")");
            }
            String xacmlId = configuration.getString(AttributeWizardTypeConfiguration.xacmlIdKey(id));
            if (xacmlId == null) {
                throw new AttributeWizardTypeConfigurationException("Error: undefined xacml-id for id \"" + id + "\" (" + attributeMappingsFile.getAbsolutePath() + ")");
            }
            String xacmlDataType = configuration.getString(AttributeWizardTypeConfiguration.xacmlDataTypeKey(id));
            if (xacmlDataType == null) {
                throw new AttributeWizardTypeConfigurationException("Error: undefined xacml-data-type for id \"" + id + "\" (" + attributeMappingsFile.getAbsolutePath() + ")");
            }
            String xacmlMatchFunction = configuration.getString(AttributeWizardTypeConfiguration.xacmlMatchFunctionKey(id));
            if (xacmlMatchFunction == null) {
                throw new AttributeWizardTypeConfigurationException("Error: undefined xacml-match-function for id \"" + id + "\" (" + attributeMappingsFile.getAbsolutePath() + ")");
            }
            String xacmlTargetElement = configuration.getString(AttributeWizardTypeConfiguration.xacmlTargetElementKey(id));
            if (xacmlTargetElement == null) {
                throw new AttributeWizardTypeConfigurationException("Error: undefined xacml-target-element for id \"" + id + "\" (" + attributeMappingsFile.getAbsolutePath() + ")");
            }
            if (AttributeWizardTypeConfiguration.checkXacmlIdExist(xacmlId)) {
                throw new AttributeWizardTypeConfigurationException("Error: duplicated xacml-id \"" + xacmlId + "\" (" + attributeMappingsFile.getAbsolutePath() + ")");
            }
            String xacmlMatchFunctionDataType = configuration.getString(AttributeWizardTypeConfiguration.xacmlMatchFunctionDataTypeKey(id));
            log.info(String.format("Adding new AttributeWizardType: id=%s, xacml-id=%s, xacml-data-type=%s, xacml-target-element=%s, xacml-match-function=%s, xacml-match-function-data-type=%s", id, xacmlId, xacmlDataType, xacmlTargetElement, xacmlMatchFunction, xacmlMatchFunctionDataType));
            if ("subject".equals(xacmlTargetElement.toLowerCase())) {
                targetElement = AttributeWizardType.TargetElement.SUBJECT;
            } else if ("resource".equals(xacmlTargetElement.toLowerCase())) {
                targetElement = AttributeWizardType.TargetElement.RESOURCE;
            } else if ("action".equals(xacmlTargetElement.toLowerCase())) {
                targetElement = AttributeWizardType.TargetElement.ACTION;
            } else if ("environment".equals(xacmlTargetElement.toLowerCase())) {
                targetElement = AttributeWizardType.TargetElement.ENVIRONMENT;
            } else {
                throw new AttributeWizardTypeConfigurationException("Error: xacml-target-element \"" + xacmlTargetElement + "\" not recognized " + "(allowed values are: subject, resource, action and environment");
            }
            list.add(new AttributeWizardType(id, xacmlId, xacmlDataType, targetElement, xacmlMatchFunction, xacmlMatchFunctionDataType));
        }
    }

    private static void initResourcePolicySetAttributeWizard() {
        for (AttributeWizardType attributeWizardType : list) {
            if (!"resource".equals(attributeWizardType.getId())) continue;
            resourcePolicySetAttributeWizard = attributeWizardType;
            return;
        }
        throw new AttributeWizardTypeConfigurationException("Cannot find id \"resource\"");
    }

    private static String xacmlDataTypeKey(String id) {
        return AttributeWizardTypeConfiguration.baseKey(id) + ".xacml-datatype";
    }

    private static String xacmlIdKey(String id) {
        return AttributeWizardTypeConfiguration.baseKey(id) + ".xacml-id";
    }

    private static String xacmlMatchFunctionKey(String id) {
        return AttributeWizardTypeConfiguration.baseKey(id) + ".xacml-match-function";
    }

    private static String xacmlMatchFunctionDataTypeKey(String id) {
        return AttributeWizardTypeConfiguration.baseKey(id) + ".xacml-match-function-datatype";
    }

    private static String xacmlTargetElementKey(String id) {
        return AttributeWizardTypeConfiguration.baseKey(id) + ".xacml-target-element";
    }

    public AttributeWizardType getActionAttributeWizard() {
        return actionPolicyAttributeWizard;
    }

    public AttributeWizardType getById(String id) {
        for (AttributeWizardType attributeWizardType : list) {
            if (!attributeWizardType.getId().equals(id)) continue;
            return attributeWizardType;
        }
        throw new UnsupportedAttributeException("id=" + id);
    }

    public AttributeWizardType getByXACMLId(String xacmlId) {
        for (AttributeWizardType attributeWizardType : list) {
            if (!attributeWizardType.getXacmlId().equals(xacmlId)) continue;
            return attributeWizardType;
        }
        throw new UnsupportedAttributeException("xacmlId=" + xacmlId);
    }

    public AttributeWizardType getResourceAttributeWizard() {
        return resourcePolicySetAttributeWizard;
    }

    public AttributeWizardType getUnrecognizedAttributeWizard(String xacmlId, String dataType) {
        return new AttributeWizardType(UNRECOGNIZED_ATTRIBUTE_ID, xacmlId, dataType, null, null, null);
    }

    public boolean idExist(String id) {
        return AttributeWizardTypeConfiguration.checkIdExist(id);
    }

    public boolean xacmlIdExist(String xacmlId) {
        return AttributeWizardTypeConfiguration.checkXacmlIdExist(xacmlId);
    }

    public boolean xacmlIdMatchesTargetElement(String xacmlId, AttributeWizardType.TargetElement targetElement) {
        try {
            AttributeWizardType attributeWizardType = this.getByXACMLId(xacmlId);
            if (attributeWizardType.getTargetElement().equals((Object)targetElement)) {
                return true;
            }
        }
        catch (UnsupportedAttributeException unsupportedAttributeException) {
            // empty catch block
        }
        return false;
    }
}

