/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common.xacml.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.glite.authz.pap.common.xacml.utils.AttributeDesignatorHelper;
import org.glite.authz.pap.common.xacml.utils.CtxAttributeTypeHelper;
import org.glite.authz.pap.common.xacml.utils.PolicyAttributeValueHelper;
import org.glite.authz.pap.common.xacml.utils.XMLObjectHelper;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.policy.AttributeDesignatorType;
import org.opensaml.xacml.policy.AttributeValueType;
import org.opensaml.xacml.policy.SubjectMatchType;
import org.opensaml.xml.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectMatchHelper
extends XMLObjectHelper<SubjectMatchType> {
    private static final QName elementQName = SubjectMatchType.DEFAULT_ELEMENT_NAME;
    private static final SubjectMatchHelper instance = new SubjectMatchHelper();
    private static final Logger log = LoggerFactory.getLogger(SubjectMatchHelper.class);

    private SubjectMatchHelper() {
    }

    public static SubjectMatchType build() {
        return (SubjectMatchType)Configuration.getBuilderFactory().getBuilder(elementQName).buildObject(elementQName);
    }

    public static List<SubjectMatchType> buildListWithDesignator(List<AttributeType> attributeList, String matchFunctionId, String matchFunctionDatatype) {
        ArrayList<SubjectMatchType> resultList = new ArrayList<SubjectMatchType>(attributeList.size());
        for (AttributeType attribute : attributeList) {
            resultList.add(SubjectMatchHelper.buildWithDesignator(attribute, matchFunctionId, matchFunctionDatatype));
        }
        return resultList;
    }

    public static SubjectMatchType buildWithDesignator(AttributeType attribute, String matchFunctionId, String matchFunctionDatatype) {
        if (attribute == null) {
            return null;
        }
        SubjectMatchType subjectMatch = SubjectMatchHelper.build();
        AttributeDesignatorType designator = AttributeDesignatorHelper.build(AttributeDesignatorType.SUBJECT_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME, attribute);
        String attributeDataType = matchFunctionDatatype == null ? attribute.getDataType() : matchFunctionDatatype;
        AttributeValueType policyAttributeValue = PolicyAttributeValueHelper.build(attributeDataType, CtxAttributeTypeHelper.getFirstValue(attribute));
        subjectMatch.setSubjectAttributeDesignator(designator);
        subjectMatch.setAttributeValue(policyAttributeValue);
        subjectMatch.setMatchId(matchFunctionId);
        return subjectMatch;
    }

    public static AttributeType getAttribute(SubjectMatchType subjectMatch) {
        AttributeValueType policyAttributeValue = subjectMatch.getAttributeValue();
        AttributeDesignatorType designator = subjectMatch.getSubjectAttributeDesignator();
        if (designator == null) {
            log.error("DESIGNATOR IS MISSING");
        }
        return CtxAttributeTypeHelper.build(designator.getAttributeId(), policyAttributeValue.getDataType(), policyAttributeValue.getValue());
    }

    public static List<AttributeType> getAttributeList(List<SubjectMatchType> subjectMatchList) {
        LinkedList<AttributeType> attributeList = new LinkedList<AttributeType>();
        if (subjectMatchList == null) {
            return attributeList;
        }
        for (SubjectMatchType subjectMatch : subjectMatchList) {
            attributeList.add(SubjectMatchHelper.getAttribute(subjectMatch));
        }
        return attributeList;
    }

    public static SubjectMatchHelper getInstance() {
        return instance;
    }
}

