/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common.xacml.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.glite.authz.pap.common.xacml.utils.AttributeDesignatorHelper;
import org.glite.authz.pap.common.xacml.utils.CtxAttributeTypeHelper;
import org.glite.authz.pap.common.xacml.utils.PolicyAttributeValueHelper;
import org.glite.authz.pap.common.xacml.utils.XMLObjectHelper;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.policy.AttributeDesignatorType;
import org.opensaml.xacml.policy.AttributeValueType;
import org.opensaml.xacml.policy.ResourceMatchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMatchHelper
extends XMLObjectHelper<ResourceMatchType> {
    private static final QName elementQName = ResourceMatchType.DEFAULT_ELEMENT_NAME;
    private static ResourceMatchHelper instance = new ResourceMatchHelper();

    private ResourceMatchHelper() {
    }

    public static ResourceMatchType build() {
        return (ResourceMatchType)builderFactory.getBuilder(elementQName).buildObject(elementQName);
    }

    public static ResourceMatchType buildWithDesignator(AttributeType attribute, String matchFunctionId, String matchFunctionDatatype) {
        if (attribute == null) {
            return null;
        }
        ResourceMatchType resourceMatch = ResourceMatchHelper.build();
        AttributeDesignatorType designator = AttributeDesignatorHelper.build(AttributeDesignatorType.RESOURCE_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME, attribute);
        String attributeDataType = matchFunctionDatatype == null ? attribute.getDataType() : matchFunctionDatatype;
        AttributeValueType policyAttributeValue = PolicyAttributeValueHelper.build(attributeDataType, CtxAttributeTypeHelper.getFirstValue(attribute));
        resourceMatch.setResourceAttributeDesignator(designator);
        resourceMatch.setAttributeValue(policyAttributeValue);
        resourceMatch.setMatchId(matchFunctionId);
        return resourceMatch;
    }

    public static List<ResourceMatchType> buildWithDesignator(List<AttributeType> attributeList, String matchFunctionId, String matchFunctionDatatype) {
        ArrayList<ResourceMatchType> resultList = new ArrayList<ResourceMatchType>(attributeList.size());
        for (AttributeType attribute : attributeList) {
            resultList.add(ResourceMatchHelper.buildWithDesignator(attribute, matchFunctionId, matchFunctionDatatype));
        }
        return resultList;
    }

    public static AttributeType getAttribute(ResourceMatchType resourceMatch) {
        AttributeValueType policyAttributeValue = resourceMatch.getAttributeValue();
        String attributeId = resourceMatch.getResourceAttributeDesignator().getAttributeId();
        return CtxAttributeTypeHelper.build(attributeId, policyAttributeValue.getDataType(), policyAttributeValue.getValue());
    }

    public static List<AttributeType> getAttributeList(List<ResourceMatchType> resourceMatchList) {
        LinkedList<AttributeType> attributeList = new LinkedList<AttributeType>();
        if (resourceMatchList == null) {
            return attributeList;
        }
        for (ResourceMatchType subjectMatch : resourceMatchList) {
            attributeList.add(ResourceMatchHelper.getAttribute(subjectMatch));
        }
        return attributeList;
    }

    public static ResourceMatchHelper getInstance() {
        return instance;
    }
}

