/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common.xacml.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.glite.authz.pap.common.xacml.utils.AttributeDesignatorHelper;
import org.glite.authz.pap.common.xacml.utils.CtxAttributeTypeHelper;
import org.glite.authz.pap.common.xacml.utils.PolicyAttributeValueHelper;
import org.glite.authz.pap.common.xacml.utils.XMLObjectHelper;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.policy.AttributeDesignatorType;
import org.opensaml.xacml.policy.AttributeValueType;
import org.opensaml.xacml.policy.EnvironmentMatchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentMatchHelper
extends XMLObjectHelper<EnvironmentMatchType> {
    private static final QName elementQName = EnvironmentMatchType.DEFAULT_ELEMENT_QNAME;
    private static EnvironmentMatchHelper instance = new EnvironmentMatchHelper();

    private EnvironmentMatchHelper() {
    }

    public static EnvironmentMatchType build() {
        return (EnvironmentMatchType)builderFactory.getBuilder(elementQName).buildObject(elementQName);
    }

    public static EnvironmentMatchType buildWithDesignator(AttributeType attribute, String matchFunctionId, String matchFunctionDatatype) {
        if (attribute == null) {
            return null;
        }
        EnvironmentMatchType environmentMatch = EnvironmentMatchHelper.build();
        AttributeDesignatorType designator = AttributeDesignatorHelper.build(AttributeDesignatorType.ACTION_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME, attribute);
        String attributeDataType = matchFunctionDatatype == null ? attribute.getDataType() : matchFunctionDatatype;
        AttributeValueType policyAttributeValue = PolicyAttributeValueHelper.build(attributeDataType, CtxAttributeTypeHelper.getFirstValue(attribute));
        environmentMatch.setEnvironmentAttributeDesignator(designator);
        environmentMatch.setAttributeValue(policyAttributeValue);
        environmentMatch.setMatchId(matchFunctionId);
        return environmentMatch;
    }

    public static List<EnvironmentMatchType> buildWithDesignator(List<AttributeType> attributeList, String matchFunctionId, String matchFunctionDatatype) {
        ArrayList<EnvironmentMatchType> resultList = new ArrayList<EnvironmentMatchType>(attributeList.size());
        for (AttributeType attribute : attributeList) {
            resultList.add(EnvironmentMatchHelper.buildWithDesignator(attribute, matchFunctionId, matchFunctionDatatype));
        }
        return resultList;
    }

    public static AttributeType getAttribute(EnvironmentMatchType environmentMatch) {
        AttributeValueType policyAttributeValue = environmentMatch.getAttributeValue();
        String attributeId = environmentMatch.getEnvironmentAttributeDesignator().getAttributeId();
        return CtxAttributeTypeHelper.build(attributeId, policyAttributeValue.getDataType(), policyAttributeValue.getValue());
    }

    public static List<AttributeType> getAttributeList(List<EnvironmentMatchType> environmentMatchList) {
        LinkedList<AttributeType> attributeList = new LinkedList<AttributeType>();
        if (environmentMatchList == null) {
            return attributeList;
        }
        for (EnvironmentMatchType subjectMatch : environmentMatchList) {
            attributeList.add(EnvironmentMatchHelper.getAttribute(subjectMatch));
        }
        return attributeList;
    }

    public static EnvironmentMatchHelper getInstance() {
        return instance;
    }
}

