/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.common;

import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.INIConfiguration;
import org.glite.authz.pap.common.exceptions.NullArgumentException;
import org.glite.authz.pap.common.exceptions.PAPConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAPConfiguration {
    private static final String DEFAULT_AUTHZ_PATH_PREFIX = "/opt/argus";
    private static final String DEFAULT_PAP_HOMEDIR_NAME = "pap";
    private static final String DEFAULT_PAP_HOME = "/opt/argus/pap";
    private static final String DEFAULT_PAP_CONFIGURATION_DIR = "/opt/argus/pap/conf";
    private static final String DEFAULT_PAP_REPOSITORY_DIR = "/opt/argus/pap/repository";
    private static final String DEFAULT_PAP_AUTHZ_FILE_NAME = "pap_authorization.ini";
    private static final String DEFAULT_PAP_CONFIGURATION_FILE_NAME = "pap_configuration.ini";
    public static final String MONITORING_PROPERTY_PREFIX = "pap-monitoring";
    public static final String REPOSITORY_STANZA = "repository";
    public static final String STANDALONE_SERVICE_STANZA = "standalone-service";
    public static final String PAPS_STANZA = "paps";
    public static final String SECURITY_STANZA = "security";
    public static final String DEFAULT_WEBAPP_CONTEXT = "pap";
    static final Logger logger = LoggerFactory.getLogger(PAPConfiguration.class);
    private static volatile PAPConfiguration instance;
    private CompositeConfiguration configuration = new CompositeConfiguration();
    private INIConfiguration startupConfiguration;
    private X509CertChainValidatorExt certChainValidator = null;

    private PAPConfiguration(String papConfigurationDir) {
        if (papConfigurationDir == null) {
            logger.warn("No configuration dir defined for PAP configuration initialization!");
            if (System.getProperty("PAP_HOME") != null) {
                logger.info("PAP_HOME system property defined. Will look in $PAP_HOME/conf for the configuration file!");
                this.configuration.setProperty("papConfigurationDir", (Object)(System.getProperty("PAP_HOME") + "/conf"));
            } else {
                logger.warn("Using hardcoded configuration directory: /opt/argus/pap/conf");
                this.configuration.setProperty("papConfigurationDir", (Object)DEFAULT_PAP_CONFIGURATION_DIR);
            }
        } else {
            this.configuration.setProperty("papConfigurationDir", (Object)papConfigurationDir);
        }
        this.loadStartupConfiguration();
    }

    public static synchronized PAPConfiguration instance() {
        if (instance == null) {
            throw new PAPConfigurationException("Please initialize configuration before calling the instance method!");
        }
        return instance;
    }

    public static PAPConfiguration initialize(ServletContext context) {
        if (context == null) {
            throw new NullArgumentException("Please provide a value for the 'context' argument! null is not a valid value in this context.");
        }
        if (instance == null) {
            String papConfDir = context.getInitParameter("papConfigurationDir");
            return PAPConfiguration.initialize(papConfDir);
        }
        return instance;
    }

    public static PAPConfiguration initialize() {
        if (instance == null) {
            return PAPConfiguration.initialize((String)null);
        }
        return instance;
    }

    public static PAPConfiguration initialize(String papConfigurationDir) {
        if (instance == null) {
            instance = new PAPConfiguration(papConfigurationDir);
        }
        return instance;
    }

    private void loadStartupConfiguration() {
        String papConfDir = this.configuration.getString("papConfigurationDir");
        File papConfFile = new File(papConfDir + "/" + DEFAULT_PAP_CONFIGURATION_FILE_NAME);
        if (!papConfFile.exists()) {
            throw new PAPConfigurationException("PAP startup configuration file does not exists on path:" + papConfFile.getAbsolutePath());
        }
        try {
            this.startupConfiguration = new INIConfiguration(papConfFile);
            this.configuration.addConfiguration((Configuration)this.startupConfiguration);
        }
        catch (ConfigurationException e) {
            logger.error("Error parsing PAP distribution configuration: " + e.getMessage(), (Throwable)e);
            throw new PAPConfigurationException("Error parsing PAP distribution configuration: " + e.getMessage(), e);
        }
    }

    public String getPAPConfigurationDir() {
        return this.configuration.getString("papConfigurationDir");
    }

    public String getPAPRepositoryDir() {
        return this.configuration.getString("repository.location", System.getProperty("PAP_HOME") + "/repository");
    }

    public String getPapAuthzConfigurationFileName() {
        return this.getPAPConfigurationDir() + "/" + DEFAULT_PAP_AUTHZ_FILE_NAME;
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.configuration.getBigDecimal(key, defaultValue);
    }

    public BigDecimal getBigDecimal(String key) {
        return this.configuration.getBigDecimal(key);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.configuration.getBigInteger(key, defaultValue);
    }

    public BigInteger getBigInteger(String key) {
        return this.configuration.getBigInteger(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.configuration.getBoolean(key, defaultValue);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.configuration.getBoolean(key, defaultValue);
    }

    public boolean getBoolean(String key) {
        return this.configuration.getBoolean(key);
    }

    public byte getByte(String key, byte defaultValue) {
        return this.configuration.getByte(key, defaultValue);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return this.configuration.getByte(key, defaultValue);
    }

    public byte getByte(String key) {
        return this.configuration.getByte(key);
    }

    public double getDouble(String key, double defaultValue) {
        return this.configuration.getDouble(key, defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) {
        return this.configuration.getDouble(key, defaultValue);
    }

    public double getDouble(String key) {
        return this.configuration.getDouble(key);
    }

    public float getFloat(String key, float defaultValue) {
        return this.configuration.getFloat(key, defaultValue);
    }

    public Float getFloat(String key, Float defaultValue) {
        return this.configuration.getFloat(key, defaultValue);
    }

    public float getFloat(String key) {
        return this.configuration.getFloat(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.configuration.getInt(key, defaultValue);
    }

    public int getInt(String key) {
        return this.configuration.getInt(key);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return this.configuration.getInteger(key, defaultValue);
    }

    public Iterator getKeys() {
        return this.configuration.getKeys();
    }

    public Iterator getKeys(String key) {
        return this.configuration.getKeys(key);
    }

    public List getList(String key, List defaultValue) {
        return this.configuration.getList(key, defaultValue);
    }

    public List getList(String key) {
        return this.configuration.getList(key);
    }

    public long getLong(String key, long defaultValue) {
        return this.configuration.getLong(key, defaultValue);
    }

    public Long getLong(String key, Long defaultValue) {
        return this.configuration.getLong(key, defaultValue);
    }

    public long getLong(String key) {
        return this.configuration.getLong(key);
    }

    public Properties getProperties(String key, Properties defaults) {
        return this.configuration.getProperties(key, defaults);
    }

    public Properties getProperties(String key) {
        return this.configuration.getProperties(key);
    }

    public Object getProperty(String key) {
        return this.configuration.getProperty(key);
    }

    public short getShort(String key, short defaultValue) {
        return this.configuration.getShort(key, defaultValue);
    }

    public Short getShort(String key, Short defaultValue) {
        return this.configuration.getShort(key, defaultValue);
    }

    public short getShort(String key) {
        return this.configuration.getShort(key);
    }

    public String getString(String key, String defaultValue) {
        return this.configuration.getString(key, defaultValue);
    }

    public String getString(String key) {
        return this.configuration.getString(key);
    }

    public String[] getStringArray(String key) {
        return this.configuration.getStringArray(key);
    }

    public void clearDistributionProperty(String key) {
        this.configuration.clearProperty(key);
    }

    public void setDistributionProperty(String key, Object value) {
        this.startupConfiguration.setProperty(key, value);
    }

    public void saveStartupConfiguration() {
        try {
            this.startupConfiguration.save();
        }
        catch (ConfigurationException e) {
            throw new PAPConfigurationException("Error saving policy distribution configuration: " + e.getMessage(), e);
        }
    }

    public Configuration subset(String prefix) {
        return this.configuration.subset(prefix);
    }

    public void setMonitoringProperty(String name, Object value) {
        this.configuration.setProperty("pap-monitoring." + name, value);
    }

    public Object getMonitoringProperty(String name) {
        return this.configuration.getProperty("pap-monitoring." + name);
    }

    public synchronized X509CertChainValidatorExt getCertchainValidator() {
        return this.certChainValidator;
    }

    public void setCertChainValidator(X509CertChainValidatorExt certChainValidator) {
        this.certChainValidator = certChainValidator;
    }
}

