/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.client.impl.axis;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import org.bouncycastle.openssl.PasswordFinder;
import org.glite.authz.pap.client.impl.axis.CANLAxis1SocketFactory;
import org.glite.authz.pap.client.impl.axis.CANLAxis1SocketFactoryConfiguration;
import org.glite.authz.pap.client.impl.axis.CANLAxis1SocketFactoryConfigurator;
import org.italiangrid.utils.https.impl.canl.CANLListener;
import org.italiangrid.voms.util.CertificateValidatorBuilder;

public class DefaultConfigurator
implements CANLAxis1SocketFactoryConfigurator,
CANLAxis1SocketFactoryConfiguration {
    public static final String DEFAULT_TRUST_ANCHORS_DIR = "/etc/grid-security/certificates";
    public static final String DEFAULT_PROTOCOL = "SSLv3";
    public static final String DEFAULT_SECURE_RANDOM = "SHA1PRNG";
    public static final String DEFAULT_SSL_CERT_FILE = "/etc/grid-security/hostcert.pem";
    public static final String DEFAULT_SSL_KEY = "/etc/grid-security/hostkey.pem";
    public static final boolean DEFAULT_CHECK_HOSTNAME_POLICY = false;
    public static final long DEFAULT_REFRESH_INTERVAL = 60000L;
    public static final int DEFAULT_TIMEOUT = 60000;
    private String sslProtocol = "SSLv3";
    private String trustAnchorsDir = "/etc/grid-security/certificates";
    private String certFile = "/etc/grid-security/hostcert.pem";
    private String keyFile = "/etc/grid-security/hostkey.pem";
    private String keyPassword = null;
    private String proxyFile = null;
    private long refreshInterval = 60000L;
    private int timeout = 60000;
    private boolean enforcingHostnameChecks = false;
    private String secureRandomAlgorithm = "SHA1PRNG";
    private static volatile X509CertChainValidatorExt validator = null;
    private PasswordFinder passwordFinder = null;

    private synchronized X509CertChainValidatorExt getValidator() {
        if (validator == null) {
            CANLListener l = new CANLListener();
            validator = CertificateValidatorBuilder.buildCertificateValidator((String)this.trustAnchorsDir, (ValidationErrorListener)l, (StoreUpdateListener)l, (long)this.refreshInterval);
        }
        return validator;
    }

    public synchronized void configure(CANLAxis1SocketFactory factory) {
        factory.setSecureRandomAlgorithm(this.getSecureRandomAlgorithm());
        factory.setSslProtocol(this.getSslProtocol());
        factory.setCertChainValidator(this.getValidator());
        factory.setCertFile(this.getCertFile());
        factory.setKeyFile(this.getKeyFile());
        factory.setKeyPassword(this.getKeyPassword());
        factory.setProxyFile(this.getProxyFile());
        factory.setTimeout(this.getTimeout());
        factory.setEnforcingHostnameChecks(this.isEnforcingHostnameChecks());
    }

    public synchronized String getSslProtocol() {
        return this.sslProtocol;
    }

    public synchronized void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public synchronized String getTrustAnchorsDir() {
        return this.trustAnchorsDir;
    }

    public synchronized void setTrustAnchorsDir(String trustAnchorsDir) {
        this.trustAnchorsDir = trustAnchorsDir;
    }

    public synchronized String getCertFile() {
        return this.certFile;
    }

    public synchronized void setCertFile(String certFile) {
        this.certFile = certFile;
    }

    public synchronized String getKeyFile() {
        return this.keyFile;
    }

    public synchronized void setKeyFile(String keyFile) {
        this.keyFile = keyFile;
    }

    public synchronized String getKeyPassword() {
        return this.keyPassword;
    }

    public synchronized void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public synchronized String getProxyFile() {
        return this.proxyFile;
    }

    public synchronized void setProxyFile(String proxyFile) {
        this.proxyFile = proxyFile;
    }

    public synchronized long getRefreshInterval() {
        return this.refreshInterval;
    }

    public synchronized void setRefreshInterval(long refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public synchronized int getTimeout() {
        return this.timeout;
    }

    public synchronized void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public synchronized boolean isEnforcingHostnameChecks() {
        return this.enforcingHostnameChecks;
    }

    public synchronized void setEnforcingHostnameChecks(boolean enforcingHostnameChecks) {
        this.enforcingHostnameChecks = enforcingHostnameChecks;
    }

    public synchronized String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public synchronized void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }
}

