/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.policyprovisioning;

import java.util.LinkedList;
import java.util.List;
import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.utils.PolicySetHelper;
import org.glite.authz.pap.distribution.DistributionModule;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.repository.exceptions.NotFoundException;
import org.glite.authz.pap.services.ServicesUtils;
import org.opensaml.xacml.XACMLObject;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetPoliciesForPDPOperation
extends BasePAPOperation<List<XACMLObject>> {
    private GetPoliciesForPDPOperation() {
    }

    public static GetPoliciesForPDPOperation instance() {
        return new GetPoliciesForPDPOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<XACMLObject> doExecute() {
        this.log.debug("Executing PDP query...");
        LinkedList<XACMLObject> resultList = new LinkedList<XACMLObject>();
        PolicySetType rootPolicySet = ServicesUtils.makeRootPolicySet();
        resultList.add((XACMLObject)rootPolicySet);
        List<PapContainer> papContainerList = PapContainer.getContainers(PapManager.getInstance().getAllPaps());
        for (PapContainer papContainer : papContainerList) {
            if (!papContainer.getPap().isEnabled()) continue;
            this.log.info("Adding PAP: " + papContainer.getPap().getAlias());
            try {
                PolicySetType papPolicySetNoReferences;
                Object object;
                if (papContainer.getPap().isLocal()) {
                    object = ServicesUtils.highLevelOperationLock;
                    synchronized (object) {
                        papPolicySetNoReferences = this.getPolicySetNoReferences(papContainer, papContainer.getRootPolicySetId());
                    }
                }
                object = DistributionModule.storePoliciesLock;
                synchronized (object) {
                    papPolicySetNoReferences = this.getPolicySetNoReferences(papContainer, papContainer.getRootPolicySetId());
                }
                PolicySetHelper.addPolicySet(rootPolicySet, papPolicySetNoReferences);
                TypeStringUtils.releaseUnneededMemory(papPolicySetNoReferences);
            }
            catch (NotFoundException e) {}
        }
        TypeStringUtils.releaseUnneededMemory(rootPolicySet);
        this.log.debug("PDP query executed: retrieved " + resultList.size() + " elements (Policy/PolicySet)");
        return resultList;
    }

    private PolicySetType getPolicySetNoReferences(PapContainer papContainer, String policySetId) {
        PolicySetType policySetNoRef = papContainer.getPolicySet(policySetId);
        List<String> idReferenceList = PolicySetHelper.getPolicySetIdReferencesValues(policySetNoRef);
        for (String childPolicySetId : idReferenceList) {
            try {
                PolicySetType childPolicySetNoRef = this.getPolicySetNoReferences(papContainer, childPolicySetId);
                PolicySetHelper.addPolicySet(policySetNoRef, childPolicySetNoRef);
                TypeStringUtils.releaseUnneededMemory(childPolicySetNoRef);
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            PolicySetHelper.deletePolicySetReference(policySetNoRef, childPolicySetId);
        }
        idReferenceList = PolicySetHelper.getPolicyIdReferencesValues(policySetNoRef);
        for (String policyIdReference : idReferenceList) {
            try {
                PolicyType policy = papContainer.getPolicy(policyIdReference);
                PolicySetHelper.addPolicy(policySetNoRef, policy);
                TypeStringUtils.releaseUnneededMemory(policy);
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            PolicySetHelper.deletePolicyReference(policySetNoRef, policyIdReference);
        }
        return policySetNoRef;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_READ_LOCAL, PAPPermission.PermissionFlags.POLICY_READ_REMOTE));
    }
}

