/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.policyprovisioning;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.utils.PolicySetHelper;
import org.glite.authz.pap.common.xacml.wizard.PolicyWizard;
import org.glite.authz.pap.distribution.DistributionModule;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.services.ServicesUtils;
import org.opensaml.xacml.XACMLObject;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetPoliciesForPAPOperation
extends BasePAPOperation<List<XACMLObject>> {
    private GetPoliciesForPAPOperation() {
    }

    public static GetPoliciesForPAPOperation instance() {
        return new GetPoliciesForPAPOperation();
    }

    @Override
    protected List<XACMLObject> doExecute() {
        this.log.debug("Executing PAP query...");
        LinkedList<XACMLObject> resultList = new LinkedList<XACMLObject>();
        ArrayList<PapContainer> papContainerList = new ArrayList<PapContainer>(PapContainer.getContainers(PapManager.getInstance().getPublicPaps()));
        PolicySetType rootPolicySet = ServicesUtils.makeRootPolicySet();
        resultList.add((XACMLObject)rootPolicySet);
        for (PapContainer papContainer : papContainerList) {
            List<XACMLObject> papXACMLObjectList = this.getPublic(papContainer);
            if (papXACMLObjectList.size() <= 0) continue;
            PolicySetType papRootPolicySet = (PolicySetType)papXACMLObjectList.get(0);
            List<String> policySetIdList = PolicySetHelper.getPolicySetIdReferencesValues(papRootPolicySet);
            List<String> policyIdList = PolicySetHelper.getPolicyIdReferencesValues(papRootPolicySet);
            TypeStringUtils.releaseUnneededMemory(papRootPolicySet);
            for (String id : policySetIdList) {
                PolicySetHelper.addPolicySetReference(rootPolicySet, id);
            }
            for (String id : policyIdList) {
                PolicySetHelper.addPolicySetReference(rootPolicySet, id);
            }
            papXACMLObjectList.remove(papRootPolicySet);
            resultList.addAll(papXACMLObjectList);
        }
        this.log.debug("PAP query executed: retrieved " + resultList.size() + " elements (Policy/PolicySet)");
        return resultList;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_READ_LOCAL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<XACMLObject> getPublic(PapContainer papContainer) {
        List<PolicyType> policyList;
        List<PolicySetType> policySetList;
        Object object;
        LinkedList<XACMLObject> resultList = new LinkedList<XACMLObject>();
        LinkedList<PolicySetType> resultPolicySetList = new LinkedList<PolicySetType>();
        if (papContainer.getPap().isLocal()) {
            object = ServicesUtils.highLevelOperationLock;
            synchronized (object) {
                policySetList = papContainer.getAllPolicySets();
                policyList = papContainer.getAllPolicies();
            }
        }
        object = DistributionModule.storePoliciesLock;
        synchronized (object) {
            policySetList = papContainer.getAllPolicySets();
            policyList = papContainer.getAllPolicies();
        }
        for (PolicySetType policySet : policySetList) {
            resultPolicySetList.add(policySet);
        }
        LinkedList<PolicyType> resultPolicyList = new LinkedList<PolicyType>();
        boolean removedAtLeastOnePrivatePolicy = false;
        for (PolicyType policy : policyList) {
            String policyId = policy.getPolicyId();
            TypeStringUtils.releaseUnneededMemory(policy);
            if (PolicyWizard.isPublic(policyId)) {
                resultPolicyList.add(policy);
                continue;
            }
            for (PolicySetType policySet : resultPolicySetList) {
                if (!PolicySetHelper.deletePolicyReference(policySet, policyId)) continue;
                removedAtLeastOnePrivatePolicy = true;
            }
        }
        if (removedAtLeastOnePrivatePolicy) {
            for (PolicySetType policySet : resultPolicySetList) {
                TypeStringUtils.releaseUnneededMemory(policySet);
            }
        }
        this.log.debug("Adding " + resultPolicySetList.size() + " PolicySet elements from PAP \"" + papContainer.getPap().getId() + "\"");
        resultList.addAll(resultPolicySetList);
        this.log.debug("Adding " + policyList.size() + " Policy elements from PAP \"" + papContainer.getPap().getId() + "\"");
        resultList.addAll(resultPolicyList);
        return resultList;
    }
}

