/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.policymanagement;

import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.services.XACMLPolicyManagementServiceException;
import org.opensaml.xacml.policy.PolicySetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatePolicySetOperation
extends BasePAPOperation<Boolean> {
    private String alias;
    private String version;
    private PolicySetType policySet;

    public UpdatePolicySetOperation(String alias, String version, PolicySetType policySet) {
        this.alias = alias;
        this.version = version;
        this.policySet = policySet;
    }

    public static UpdatePolicySetOperation instance(String alias, String version, PolicySetType policySet) {
        return new UpdatePolicySetOperation(alias, version, policySet);
    }

    @Override
    protected Boolean doExecute() {
        Pap pap;
        if (this.alias == null) {
            this.alias = "default";
        }
        if ((pap = PapManager.getInstance().getPap(this.alias)).isRemote()) {
            throw new XACMLPolicyManagementServiceException("Forbidden operation for a remote PAP");
        }
        PapContainer papContainer = new PapContainer(pap);
        if (!papContainer.hasPolicySet(this.policySet.getPolicySetId())) {
            return false;
        }
        papContainer.updatePolicySet(this.version, this.policySet);
        return true;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_WRITE, PAPPermission.PermissionFlags.POLICY_READ_LOCAL));
    }
}

