/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.policymanagement;

import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.services.XACMLPolicyManagementServiceException;
import org.opensaml.xacml.policy.PolicyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatePolicyOperation
extends BasePAPOperation<Boolean> {
    String alias;
    String version;
    PolicyType policy;

    private UpdatePolicyOperation(String alias, String version, PolicyType policy) {
        this.alias = alias;
        this.version = version;
        this.policy = policy;
    }

    public static UpdatePolicyOperation instance(String alias, String version, PolicyType policy) {
        return new UpdatePolicyOperation(alias, version, policy);
    }

    @Override
    protected Boolean doExecute() {
        Pap pap;
        if (this.alias == null) {
            this.alias = "default";
        }
        if ((pap = PapManager.getInstance().getPap(this.alias)).isRemote()) {
            throw new XACMLPolicyManagementServiceException("Forbidden operation for a remote PAP");
        }
        PapContainer papContainer = new PapContainer(pap);
        if (!papContainer.hasPolicy(this.policy.getPolicyId())) {
            return false;
        }
        papContainer.updatePolicy(this.version, this.policy);
        return true;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_WRITE, PAPPermission.PermissionFlags.POLICY_READ_LOCAL));
    }
}

