/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.policymanagement;

import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.wizard.WizardUtils;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.services.XACMLPolicyManagementServiceException;
import org.opensaml.xacml.policy.PolicyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorePolicyOperation
extends BasePAPOperation<String> {
    String alias;
    String idPrefix;
    PolicyType policy;

    protected StorePolicyOperation(String alias, String idPrefix, PolicyType policy) {
        this.alias = alias;
        this.idPrefix = idPrefix;
        this.policy = policy;
    }

    public static StorePolicyOperation instance(String alias, String idPrefix, PolicyType policy) {
        return new StorePolicyOperation(alias, idPrefix, policy);
    }

    @Override
    protected String doExecute() {
        Pap pap;
        if (this.alias == null) {
            this.alias = "default";
        }
        if ((pap = PapManager.getInstance().getPap(this.alias)).isRemote()) {
            throw new XACMLPolicyManagementServiceException("Forbidden operation for a remote PAP");
        }
        PapContainer papContainer = new PapContainer(pap);
        String policyId = WizardUtils.generateId(this.idPrefix);
        this.policy.setPolicyId(policyId);
        papContainer.storePolicy(this.policy);
        TypeStringUtils.releaseUnneededMemory(this.policy);
        return policyId;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_WRITE));
    }
}

