/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.policymanagement;

import java.util.List;
import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.xacml.wizard.PolicyWizard;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.repository.exceptions.NotFoundException;
import org.glite.authz.pap.repository.exceptions.RepositoryException;
import org.glite.authz.pap.services.XACMLPolicyManagementServiceException;
import org.opensaml.xacml.policy.PolicyType;
import org.opensaml.xacml.policy.RuleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveObjectByIdAndReferencesOperation
extends BasePAPOperation<Boolean> {
    String alias;
    String id;

    private RemoveObjectByIdAndReferencesOperation(String alias, String id) {
        this.alias = alias;
        this.id = id;
    }

    public static RemoveObjectByIdAndReferencesOperation instance(String alias, String id) {
        return new RemoveObjectByIdAndReferencesOperation(alias, id);
    }

    @Override
    protected Boolean doExecute() {
        Pap pap;
        if (this.id == null) {
            throw new XACMLPolicyManagementServiceException("id is null");
        }
        if (this.alias == null) {
            this.alias = "default";
        }
        if ((pap = PapManager.getInstance().getPap(this.alias)).isRemote()) {
            throw new XACMLPolicyManagementServiceException("Forbidden operation for a remote PAP");
        }
        PapContainer papContainer = new PapContainer(pap);
        if (papContainer.getRootPolicySetId().equals(this.id)) {
            throw new RepositoryException("Invalid operation: cannot remove the local PAP root policy set");
        }
        if (papContainer.hasPolicy(this.id)) {
            papContainer.removePolicyAndReferences(this.id);
            return true;
        }
        if (papContainer.hasPolicySet(this.id)) {
            papContainer.removePolicySetAndReferences(this.id);
            return true;
        }
        this.removeRule(papContainer, this.id);
        return true;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_WRITE));
    }

    private void removeRule(PapContainer papContainer, String id) {
        List<PolicyType> policyList = papContainer.getAllPolicies();
        PolicyType targetPolicy = null;
        RuleType targetRule = null;
        for (PolicyType policy : policyList) {
            List ruleList = policy.getRules();
            for (RuleType rule : ruleList) {
                if (!id.equals(rule.getRuleId())) continue;
                targetRule = rule;
                break;
            }
            if (targetRule == null) continue;
            ruleList.remove(targetRule);
            targetPolicy = policy;
            break;
        }
        if (targetPolicy == null) {
            throw new NotFoundException("Id not found: " + id);
        }
        if (targetPolicy.getRules().size() == 0) {
            papContainer.removePolicyAndReferences(targetPolicy.getPolicyId());
        } else {
            String version = targetPolicy.getVersion();
            PolicyWizard.increaseVersion(targetPolicy);
            papContainer.updatePolicy(version, targetPolicy);
        }
    }
}

