/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.policymanagement;

import java.util.List;
import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.opensaml.xacml.policy.PolicySetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListRemotePolicySetOperation
extends BasePAPOperation<PolicySetType[]> {
    private Pap ps;

    private ListRemotePolicySetOperation(Pap ps) {
        this.ps = ps;
    }

    public static ListRemotePolicySetOperation instance(Pap ps) {
        return new ListRemotePolicySetOperation(ps);
    }

    @Override
    protected PolicySetType[] doExecute() {
        PapContainer localPAP = new PapContainer(this.ps);
        List<PolicySetType> policySetList = localPAP.getAllPolicySets();
        PolicySetType[] policySetArray = new PolicySetType[policySetList.size()];
        for (int i = 0; i < policySetList.size(); ++i) {
            policySetArray[i] = policySetList.get(i);
        }
        this.log.info("Returning " + policySetArray.length + " policy sets");
        return policySetArray;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_READ_REMOTE));
    }
}

