/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.policymanagement;

import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.repository.exceptions.NotFoundException;
import org.opensaml.xacml.policy.PolicySetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetRemotePolicySetOperation
extends BasePAPOperation<PolicySetType> {
    private Pap ps;
    private String policySetId;

    protected GetRemotePolicySetOperation(Pap ps, String policySetId) {
        this.ps = ps;
        this.policySetId = policySetId;
    }

    public static GetRemotePolicySetOperation instance(Pap ps, String policySetId) {
        return new GetRemotePolicySetOperation(ps, policySetId);
    }

    @Override
    protected PolicySetType doExecute() {
        PapContainer papContainer = new PapContainer(this.ps);
        if (!papContainer.hasPolicySet(this.policySetId)) {
            throw new NotFoundException("PolicySet '" + this.policySetId + "' not found.");
        }
        PolicySetType policySet = papContainer.getPolicySet(this.policySetId);
        return policySet;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_READ_REMOTE));
    }
}

