/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.policymanagement;

import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.repository.exceptions.NotFoundException;
import org.opensaml.xacml.policy.PolicyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetRemotePolicyOperation
extends BasePAPOperation<PolicyType> {
    private Pap ps;
    private String policyId;

    protected GetRemotePolicyOperation(Pap ps, String policyId) {
        this.ps = ps;
        this.policyId = policyId;
    }

    public static GetRemotePolicyOperation instance(Pap ps, String policyId) {
        return new GetRemotePolicyOperation(ps, policyId);
    }

    @Override
    protected PolicyType doExecute() {
        PapContainer papContainer = new PapContainer(this.ps);
        if (!papContainer.hasPolicy(this.policyId)) {
            throw new NotFoundException("Policy '" + this.policyId + "' not found.");
        }
        PolicyType policy = papContainer.getPolicy(this.policyId);
        return policy;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_READ_REMOTE));
    }
}

