/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.policymanagement;

import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.wizard.WizardUtils;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.services.XACMLPolicyManagementServiceException;
import org.opensaml.xacml.policy.PolicyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPoliciesOperation
extends BasePAPOperation<String[]> {
    int index;
    String alias;
    PolicyType[] policyArray;
    String[] policyIdPrefix;
    String policySetId;

    protected AddPoliciesOperation(String alias, int index, String policySetId, String[] policyIdPrefix, PolicyType[] policyArray) {
        this.alias = alias;
        this.index = index;
        this.policySetId = policySetId;
        this.policyIdPrefix = policyIdPrefix;
        this.policyArray = policyArray;
    }

    public static AddPoliciesOperation instance(String alias, int index, String policySetId, String[] policyIdPrefix, PolicyType[] policyArray) {
        return new AddPoliciesOperation(alias, index, policySetId, policyIdPrefix, policyArray);
    }

    @Override
    protected String[] doExecute() {
        Pap pap;
        if (this.alias == null) {
            this.alias = "default";
        }
        if ((pap = PapManager.getInstance().getPap(this.alias)).isRemote()) {
            throw new XACMLPolicyManagementServiceException("Forbidden operation for a remote PAP");
        }
        PapContainer papContainer = new PapContainer(pap);
        if (!papContainer.hasPolicySet(this.policySetId)) {
            this.log.warn(String.format("Policies not added because PolicySetId \"%s\" does not exists.", this.policySetId));
            return null;
        }
        String[] policyIdArray = new String[this.policyArray.length];
        for (int i = 0; i < this.policyArray.length; ++i) {
            policyIdArray[i] = WizardUtils.generateId(this.policyIdPrefix[i]);
            this.policyArray[i].setPolicyId(policyIdArray[i]);
            if (this.index == -1) {
                papContainer.addPolicy(this.index, this.policySetId, this.policyArray[i]);
            } else {
                papContainer.addPolicy(this.index + i, this.policySetId, this.policyArray[i]);
            }
            TypeStringUtils.releaseUnneededMemory(this.policyArray[i]);
            this.log.info(String.format("Added policy (policyId=\"%s\")", policyIdArray[i]));
        }
        return policyIdArray;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_WRITE));
    }
}

