/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.papmanagement;

import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.exceptions.PAPException;
import org.glite.authz.pap.distribution.DistributionModule;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.repository.exceptions.NotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshPolicyCacheOperation
extends BasePAPOperation<Boolean> {
    String papAlias;

    protected RefreshPolicyCacheOperation(String papAlias) {
        this.papAlias = papAlias;
    }

    public static RefreshPolicyCacheOperation instance(String papAlias) {
        return new RefreshPolicyCacheOperation(papAlias);
    }

    @Override
    protected Boolean doExecute() {
        Pap pap;
        PapManager papManager = PapManager.getInstance();
        try {
            pap = papManager.getPap(this.papAlias);
        }
        catch (NotFoundException e) {
            this.log.error("Unable to refresh cache, PAP not found: " + this.papAlias);
            return false;
        }
        if (!pap.isRemote()) {
            throw new PAPException("\"" + this.papAlias + "\" is local, nothing to refresh");
        }
        try {
            DistributionModule.refreshCache(pap);
        }
        catch (Throwable t) {
            throw new PAPException(t.getMessage(), t);
        }
        return true;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_READ_REMOTE, PAPPermission.PermissionFlags.POLICY_WRITE));
    }
}

