/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.highlevelpolicymanagement;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.utils.PolicySetHelper;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizard;
import org.glite.authz.pap.common.xacml.wizard.PolicyWizard;
import org.glite.authz.pap.common.xacml.wizard.TargetWizard;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.services.XACMLPolicyManagementServiceException;
import org.glite.authz.pap.services.highlevel_policy_management.axis_skeletons.UnbanResult;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnbanOperation
extends BasePAPOperation<UnbanResult> {
    private static final Logger log = LoggerFactory.getLogger(UnbanOperation.class);
    private String alias;
    private final AttributeWizard actionAttributeWizard;
    private final AttributeWizard bannedAttributeWizard;
    private final AttributeWizard resourceAttributeWizard;

    protected UnbanOperation(String alias, AttributeWizard bannedAttributeWizard, AttributeWizard resourceAttributeWizard, AttributeWizard actionAttributeWizard) {
        this.alias = alias;
        this.bannedAttributeWizard = bannedAttributeWizard;
        this.resourceAttributeWizard = resourceAttributeWizard;
        this.actionAttributeWizard = actionAttributeWizard;
    }

    public static UnbanOperation instance(String alias, AttributeWizard bannedAttributeWizard, AttributeWizard resourceAttributeWizard, AttributeWizard actionAttributeWizard) {
        return new UnbanOperation(alias, bannedAttributeWizard, resourceAttributeWizard, actionAttributeWizard);
    }

    @Override
    protected UnbanResult doExecute() {
        PolicySetType targetPolicySet;
        Pap pap;
        UnbanResult unbanResult = new UnbanResult();
        unbanResult.setConflictingPolicies(new String[0]);
        if (this.alias == null) {
            this.alias = "default";
        }
        if ((pap = PapManager.getInstance().getPap(this.alias)).isRemote()) {
            throw new XACMLPolicyManagementServiceException("Forbidden operation for a remote PAP");
        }
        PapContainer papContainer = new PapContainer(pap);
        List<PolicySetType> targetPolicySetList = this.getTargetPolicySetList(papContainer);
        if (targetPolicySetList.isEmpty()) {
            log.debug("targetPolicySet not found");
            unbanResult.setStatusCode(1);
            return unbanResult;
        }
        PolicyType targetPolicy = null;
        Iterator<PolicySetType> i$ = targetPolicySetList.iterator();
        while (i$.hasNext() && (targetPolicy = this.getTargetPolicy(papContainer, targetPolicySet = i$.next())) == null) {
        }
        if (targetPolicy == null) {
            log.debug("targetPolicy not found");
            unbanResult.setStatusCode(1);
            return unbanResult;
        }
        PolicyWizard policyWizard = new PolicyWizard(targetPolicy);
        TypeStringUtils.releaseUnneededMemory(targetPolicy);
        if (policyWizard.removeDenyRuleForAttribute(this.bannedAttributeWizard)) {
            log.debug("ban rule found, updating policy");
            if (policyWizard.getNumberOfRules() == 0) {
                papContainer.removePolicyAndReferences(policyWizard.getPolicyId());
            } else {
                String oldVersion = policyWizard.getVersionString();
                policyWizard.increaseVersion();
                papContainer.updatePolicy(oldVersion, policyWizard.getXACML());
            }
            unbanResult.setStatusCode(0);
            return unbanResult;
        }
        unbanResult.setStatusCode(1);
        return unbanResult;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_WRITE, PAPPermission.PermissionFlags.POLICY_READ_LOCAL));
    }

    private PolicyType getTargetPolicy(PapContainer papContainer, PolicySetType targetPolicySet) {
        List<String> policyIdList = PolicySetHelper.getPolicyIdReferencesValues(targetPolicySet);
        TypeStringUtils.releaseUnneededMemory(targetPolicySet);
        TargetWizard policyTargetWizard = new TargetWizard(this.actionAttributeWizard);
        for (String policyId : policyIdList) {
            PolicyType repositoryPolicy = papContainer.getPolicy(policyId);
            if (policyTargetWizard.isEquivalent(repositoryPolicy.getTarget())) {
                return repositoryPolicy;
            }
            TypeStringUtils.releaseUnneededMemory(repositoryPolicy);
        }
        return null;
    }

    private List<PolicySetType> getTargetPolicySetList(PapContainer papContainer) {
        LinkedList<PolicySetType> targetPolicySetList = new LinkedList<PolicySetType>();
        TargetWizard policySetTargetWizard = new TargetWizard(this.resourceAttributeWizard);
        PolicySetType rootPAPPolicySet = papContainer.getRootPolicySet();
        List<String> policySetIdList = PolicySetHelper.getPolicySetIdReferencesValues(rootPAPPolicySet);
        TypeStringUtils.releaseUnneededMemory(rootPAPPolicySet);
        for (String policySetId : policySetIdList) {
            PolicySetType policySet = papContainer.getPolicySet(policySetId);
            if (policySetTargetWizard.isEquivalent(policySet.getTarget())) {
                targetPolicySetList.add(policySet);
            }
            TypeStringUtils.releaseUnneededMemory(policySet);
        }
        return targetPolicySetList;
    }
}

