/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.highlevelpolicymanagement;

import java.util.List;
import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.common.Pap;
import org.glite.authz.pap.common.xacml.impl.TypeStringUtils;
import org.glite.authz.pap.common.xacml.utils.ObligationsHelper;
import org.glite.authz.pap.common.xacml.utils.PolicyHelper;
import org.glite.authz.pap.common.xacml.utils.PolicySetHelper;
import org.glite.authz.pap.common.xacml.wizard.AttributeWizard;
import org.glite.authz.pap.common.xacml.wizard.ObligationWizard;
import org.glite.authz.pap.common.xacml.wizard.PolicySetWizard;
import org.glite.authz.pap.common.xacml.wizard.PolicyWizard;
import org.glite.authz.pap.common.xacml.wizard.RuleWizard;
import org.glite.authz.pap.papmanagement.PapContainer;
import org.glite.authz.pap.papmanagement.PapManager;
import org.glite.authz.pap.services.HighLevelPolicyManagementServiceException;
import org.glite.authz.pap.services.XACMLPolicyManagementServiceException;
import org.opensaml.xacml.policy.EffectType;
import org.opensaml.xacml.policy.ObligationsType;
import org.opensaml.xacml.policy.PolicySetType;
import org.opensaml.xacml.policy.PolicyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRuleOperation
extends BasePAPOperation<String> {
    private String actionId;
    private String actionValue;
    private String resourceValue;
    private String obligationValue;
    private ObligationScopeType obligationScope;
    private String alias;
    private List<AttributeWizard> attributeWizardList;
    private EffectType effect;
    private boolean after;
    private String ruleId;

    protected AddRuleOperation(String alias, boolean isPermit, List<AttributeWizard> attributeWizardList, String actionValue, String resourceValue, String actionId, String ruleId, String obligationValue, String obligationScope, boolean after) {
        this.alias = alias;
        this.attributeWizardList = attributeWizardList;
        this.actionId = actionId;
        this.actionValue = actionValue;
        this.resourceValue = resourceValue;
        this.obligationValue = obligationValue;
        this.obligationScope = ObligationScopeType.valueOf(obligationScope);
        this.ruleId = ruleId;
        this.after = after;
        this.effect = isPermit ? EffectType.Permit : EffectType.Deny;
    }

    protected PolicySetType findResourcePolicySet(PapContainer pc) {
        List<PolicySetType> policySetList = pc.getAllPolicySets();
        PolicySetType targetPolicySet = null;
        for (int i = 1; i < policySetList.size(); ++i) {
            PolicySetType policySet = policySetList.get(i);
            if (!this.resourceValue.equals(PolicySetWizard.getResourceValue(policySet))) continue;
            if (targetPolicySet != null) {
                throw new HighLevelPolicyManagementServiceException("More than one resource policy sets match the given resource id!");
            }
            targetPolicySet = policySet;
        }
        policySetList = null;
        return targetPolicySet;
    }

    public static AddRuleOperation instance(String alias, boolean isPermit, List<AttributeWizard> attributeWizardList, String actionValue, String resourceValue, String actionId, String ruleId, String obligationId, String obligationScope, boolean after) {
        return new AddRuleOperation(alias, isPermit, attributeWizardList, actionValue, resourceValue, actionId, ruleId, obligationId, obligationScope, after);
    }

    @Override
    protected String doExecute() {
        Pap pap;
        if (this.alias == null) {
            this.alias = "default";
        }
        if ((pap = PapManager.getInstance().getPap(this.alias)).isRemote()) {
            throw new XACMLPolicyManagementServiceException("You cannot add rules to a remote PAP!");
        }
        if (this.actionId == null && this.actionValue == null) {
            throw new XACMLPolicyManagementServiceException("Action id and action value are both unspecified.");
        }
        RuleWizard ruleWizard = new RuleWizard(this.attributeWizardList, this.effect);
        PapContainer papContainer = new PapContainer(pap);
        if (this.actionId == null) {
            this.actionId = this.getActionId(papContainer, this.actionValue, this.resourceValue, this.after);
        }
        PolicyType actionPolicy = papContainer.getPolicy(this.actionId);
        if (this.obligationValue != null) {
            if (ObligationScopeType.action.equals((Object)this.obligationScope)) {
                if (!PolicyHelper.hasObligationWithId(actionPolicy, this.obligationValue)) {
                    ObligationWizard owiz = new ObligationWizard(this.obligationValue);
                    ObligationsType obligations = ObligationsHelper.build();
                    obligations.getObligations().add(owiz.getXACML());
                    actionPolicy.setObligations(obligations);
                }
            } else {
                PolicySetType resourcePolicySet = this.findResourcePolicySet(papContainer);
                if (!PolicySetHelper.hasObligationWithId(resourcePolicySet, this.obligationValue)) {
                    ObligationWizard owiz = new ObligationWizard(this.obligationValue);
                    ObligationsType obligations = ObligationsHelper.build();
                    obligations.getObligations().add(owiz.getXACML());
                    resourcePolicySet.setObligations(obligations);
                }
            }
        }
        int index = 0;
        if (this.ruleId != null) {
            index = PolicyHelper.indexOfRule(actionPolicy, this.ruleId);
            if (index == -1) {
                throw new XACMLPolicyManagementServiceException("ruleId not found: " + this.ruleId);
            }
            if (this.after) {
                ++index;
            }
        }
        if (this.ruleId == null && this.after) {
            index = -1;
        }
        PolicyHelper.addRule(actionPolicy, index, ruleWizard.getXACML());
        String version = actionPolicy.getVersion();
        PolicyWizard.increaseVersion(actionPolicy);
        TypeStringUtils.releaseUnneededMemory(actionPolicy);
        papContainer.updatePolicy(version, actionPolicy);
        return ruleWizard.getRuleId();
    }

    private String getActionId(PapContainer papContainer, String actionValue, String resourceValue, boolean bottom) {
        PolicySetType targetPolicySet = this.findResourcePolicySet(papContainer);
        if (targetPolicySet == null) {
            String resourceId = this.createResource(papContainer, resourceValue, bottom);
            return this.createAction(papContainer, resourceId, actionValue, bottom);
        }
        List<String> policyIdList = PolicySetHelper.getPolicyIdReferencesValues(targetPolicySet);
        PolicyType targetPolicy = null;
        for (String policyId : policyIdList) {
            PolicyType policy = papContainer.getPolicy(policyId);
            if (!actionValue.equals(PolicyWizard.getActionValue(policy))) continue;
            if (targetPolicy != null) {
                throw new HighLevelPolicyManagementServiceException("More than one action with the same value");
            }
            targetPolicy = policy;
        }
        String actionId = targetPolicy == null ? this.createAction(papContainer, targetPolicySet.getPolicySetId(), actionValue, bottom) : targetPolicy.getPolicyId();
        return actionId;
    }

    private String createResource(PapContainer papContainer, String resourceValue, boolean bottom) {
        PolicySetWizard psWizard = new PolicySetWizard(new AttributeWizard("resource", resourceValue));
        if (this.obligationValue != null && this.obligationScope.equals((Object)ObligationScopeType.resource)) {
            psWizard.addObligation(new ObligationWizard(this.obligationValue));
        }
        PolicySetType resource = psWizard.getXACML();
        String resourceId = resource.getPolicySetId();
        papContainer.storePolicySet(resource);
        PolicySetType rootPolicySet = papContainer.getRootPolicySet();
        int index = 0;
        if (bottom) {
            index = -1;
        }
        PolicySetHelper.addPolicySetReference(rootPolicySet, index, resourceId);
        String version = rootPolicySet.getVersion();
        PolicySetWizard.increaseVersion(rootPolicySet);
        papContainer.updatePolicySet(version, rootPolicySet);
        return resourceId;
    }

    private String createAction(PapContainer papContainer, String resourceId, String actionValue, boolean bottom) {
        PolicyWizard pw = new PolicyWizard(new AttributeWizard("action", actionValue));
        if (this.obligationValue != null && this.obligationScope.equals((Object)ObligationScopeType.action)) {
            pw.addObligation(new ObligationWizard(this.obligationValue));
        }
        PolicyType action = pw.getXACML();
        papContainer.storePolicy(action);
        String actionId = action.getPolicyId();
        int index = 0;
        if (bottom) {
            index = -1;
        }
        PolicySetType resource = papContainer.getPolicySet(resourceId);
        PolicySetHelper.addPolicyReference(resource, index, actionId);
        String version = resource.getVersion();
        PolicySetWizard.increaseVersion(resource);
        papContainer.updatePolicySet(version, resource);
        return actionId;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.POLICY_WRITE));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ObligationScopeType {
        action,
        resource;

    }
}

