/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz.operations.authzmanagement;

import org.glite.authz.pap.authz.AuthorizationEngine;
import org.glite.authz.pap.authz.BasePAPOperation;
import org.glite.authz.pap.authz.PAPACE;
import org.glite.authz.pap.authz.PAPAdmin;
import org.glite.authz.pap.authz.PAPContext;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.authz.exceptions.PAPAuthzException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveACEOperation
extends BasePAPOperation<Object> {
    PAPACE ace;

    private RemoveACEOperation(PAPACE ace) {
        this.ace = ace;
    }

    public static RemoveACEOperation instance(PAPACE ace) {
        return new RemoveACEOperation(ace);
    }

    @Override
    protected Object doExecute() {
        PAPAdmin admin;
        PAPContext ctxt = this.ace.getContext();
        if (ctxt == null) {
            ctxt = AuthorizationEngine.instance().getGlobalContext();
        }
        if ((admin = this.ace.getAdmin()) == null) {
            throw new PAPAuthzException("Cannot setup permissions for NULL admins!");
        }
        ctxt.getAcl().removePermissions(admin);
        return null;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(PAPPermission.of(PAPPermission.PermissionFlags.CONFIGURATION_WRITE, PAPPermission.PermissionFlags.CONFIGURATION_READ));
    }
}

