/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.glite.authz.pap.authz.PAPPermission;

public class PAPPermissionList {
    protected List<PAPPermission> permissions = new ArrayList<PAPPermission>();

    private PAPPermissionList() {
    }

    public void addPermission(PAPPermission p) {
        if (p == null) {
            return;
        }
        this.permissions.add(p);
    }

    public boolean satisfies(PAPPermission other) {
        return this.getCumulativePermission().satisfies(other);
    }

    public int size() {
        return this.permissions.size();
    }

    public static PAPPermissionList instance() {
        return new PAPPermissionList();
    }

    public String toString() {
        return StringUtils.join(this.permissions, (String)",");
    }

    public PAPPermission getCumulativePermission() {
        PAPPermission cumulativePerms = PAPPermission.getEmptyPermission();
        for (PAPPermission p : this.permissions) {
            cumulativePerms.add(p);
        }
        return cumulativePerms;
    }
}

