/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz;

import java.util.HashMap;
import java.util.Map;
import org.glite.authz.pap.authz.ACL;
import org.glite.authz.pap.authz.AuthorizationEngine;
import org.glite.authz.pap.authz.CurrentAdmin;
import org.glite.authz.pap.authz.PAPContext;
import org.glite.authz.pap.authz.PAPOperation;
import org.glite.authz.pap.authz.PAPPermission;
import org.glite.authz.pap.authz.exceptions.PAPAuthzException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePAPOperation<T>
implements PAPOperation<T> {
    protected Logger log = LoggerFactory.getLogger(BasePAPOperation.class);
    protected Map<PAPContext, PAPPermission> requiredPermission = new HashMap<PAPContext, PAPPermission>();

    protected BasePAPOperation() {
    }

    private boolean permissionsInitialized() {
        return this.requiredPermission != null && !this.requiredPermission.isEmpty();
    }

    @Override
    public final T execute() {
        this.logOperation();
        if (!this.isAllowed()) {
            this.log.info("Insufficient privileges to perform operation '" + this.getName() + "'");
            throw new PAPAuthzException("Insufficient privileges to perform operation '" + this.getName() + "'.");
        }
        return this.doExecute();
    }

    @Override
    public Map<PAPContext, PAPPermission> getRequiredPermission() {
        if (!this.permissionsInitialized()) {
            this.setupPermissions();
        }
        return this.requiredPermission;
    }

    protected abstract T doExecute();

    protected final void addRequiredPermission(PAPContext context, PAPPermission perms) {
        assert (context != null) : "Cannot add permission for a null context!";
        assert (perms != null) : "Cannot add null permissions for a context!";
        this.requiredPermission.put(context, perms);
    }

    protected final void addRequiredPermission(PAPPermission perms) {
        if (perms == null) {
            throw new IllegalArgumentException("Cannot add null permissions on the global context!");
        }
        this.requiredPermission.put(AuthorizationEngine.instance().getGlobalContext(), perms);
    }

    protected String getName() {
        return this.getClass().getSimpleName();
    }

    public final boolean isAllowed() {
        CurrentAdmin admin = CurrentAdmin.instance();
        if (!this.permissionsInitialized()) {
            this.setupPermissions();
        }
        if (this.requiredPermission.isEmpty()) {
            throw new PAPAuthzException("No required permissions defined for operation '" + this.getName() + "'.");
        }
        for (Map.Entry<PAPContext, PAPPermission> entry : this.requiredPermission.entrySet()) {
            PAPContext context = entry.getKey();
            ACL acl = entry.getKey().getAcl();
            PAPPermission perms = entry.getValue();
            if (acl == null) {
                throw new PAPAuthzException("No ACL defined for context '" + entry.getKey() + "'.");
            }
            if (admin.hasPermissions(context, perms)) continue;
            return false;
        }
        return true;
    }

    protected void logOperation() {
    }

    protected abstract void setupPermissions();
}

