/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pap.authz;

import java.io.File;
import org.glite.authz.pap.authz.AuthzConfigurationParser;
import org.glite.authz.pap.authz.CurrentAdmin;
import org.glite.authz.pap.authz.PAPContext;
import org.glite.authz.pap.common.PAPConfiguration;
import org.glite.authz.pap.common.exceptions.PAPConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationEngine {
    public static final Logger logger = LoggerFactory.getLogger(AuthorizationEngine.class);
    private static AuthorizationEngine instance;
    private PAPContext globalContext;

    private AuthorizationEngine(String papAuthzConfFile) {
        File papConfFile = new File(papAuthzConfFile);
        if (!papConfFile.exists()) {
            throw new PAPConfigurationException("PAP Authorization configuration file not found: " + papConfFile.getAbsolutePath());
        }
        this.globalContext = PAPContext.instance("global-context");
        AuthzConfigurationParser confParser = AuthzConfigurationParser.instance();
        confParser.parse(papConfFile);
        this.globalContext.setAcl(confParser.getParsedACL());
    }

    public static AuthorizationEngine initialize(String papAuthzConfFile) {
        if (instance == null) {
            instance = new AuthorizationEngine(papAuthzConfFile);
        }
        return instance;
    }

    public static AuthorizationEngine instance() {
        if (instance == null) {
            logger.warn("Authorization engine hasn't been properly initialized!");
        }
        return instance;
    }

    public void saveConfiguration() {
        String confFileName = PAPConfiguration.instance().getPapAuthzConfigurationFileName();
        AuthzConfigurationParser confParser = AuthzConfigurationParser.instance();
        confParser.save(new File(confFileName), this.getGlobalContext().getAcl());
    }

    public PAPContext getGlobalContext() {
        return this.globalContext;
    }

    public void shutdown() {
        if (CurrentAdmin.validator != null) {
            CurrentAdmin.validator.shutdown();
        }
    }
}

