/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.store.impl;

import eu.emi.security.authn.x509.helpers.trust.OpensslTrustAnchorStore;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.store.LSCInfo;
import org.italiangrid.voms.store.VOMSTrustStore;
import org.italiangrid.voms.store.VOMSTrustStoreStatusListener;
import org.italiangrid.voms.store.impl.DefaultLSCFileParser;
import org.italiangrid.voms.store.impl.LSCFile;
import org.italiangrid.voms.util.NullListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVOMSTrustStore
implements VOMSTrustStore {
    public static final String DEFAULT_VOMS_DIR = "/etc/grid-security/vomsdir";
    public static final String CERTIFICATE_FILENAME_SUFFIX = ".pem";
    public static final String LSC_FILENAME_SUFFIX = ".lsc";
    private List<String> localTrustedDirs;
    private Map<String, X509Certificate> localAACertificatesByHash = new HashMap<String, X509Certificate>();
    private Map<String, Set<LSCInfo>> localLSCInfo = new HashMap<String, Set<LSCInfo>>();
    private VOMSTrustStoreStatusListener listener;

    protected static List<String> buildDefaultTrustedDirs() {
        ArrayList<String> tDirs = new ArrayList<String>();
        tDirs.add(DEFAULT_VOMS_DIR);
        return tDirs;
    }

    public DefaultVOMSTrustStore(List<String> localTrustDirs, VOMSTrustStoreStatusListener listener) {
        if (localTrustDirs == null) {
            throw new IllegalArgumentException("Please provide a non-null list of local trust directories!");
        }
        this.localTrustedDirs = localTrustDirs;
        this.listener = listener;
        this.loadTrustInformation();
    }

    public DefaultVOMSTrustStore(VOMSTrustStoreStatusListener listener) {
        this(DefaultVOMSTrustStore.buildDefaultTrustedDirs(), listener);
    }

    public DefaultVOMSTrustStore(List<String> localTrustDirs) {
        this(localTrustDirs, NullListener.INSTANCE);
    }

    public DefaultVOMSTrustStore() {
        this(DefaultVOMSTrustStore.buildDefaultTrustedDirs());
    }

    @Override
    public synchronized List<String> getLocalTrustedDirectories() {
        return this.localTrustedDirs;
    }

    @Override
    public synchronized List<X509Certificate> getLocalAACertificates() {
        return Collections.unmodifiableList(new ArrayList<X509Certificate>(this.localAACertificatesByHash.values()));
    }

    @Override
    public synchronized LSCInfo getLSC(String voName, String hostname) {
        Set<LSCInfo> candidates = this.localLSCInfo.get(voName);
        if (candidates == null) {
            return null;
        }
        for (LSCInfo lsc : candidates) {
            if (!lsc.getHostname().equals(hostname)) continue;
            return lsc;
        }
        return null;
    }

    private void loadCertificatesFromDirectory(File directory) {
        File[] certFiles;
        this.directorySanityChecks(directory);
        this.listener.notifyCertficateLookupEvent(directory.getAbsolutePath());
        for (File f : certFiles = directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(DefaultVOMSTrustStore.CERTIFICATE_FILENAME_SUFFIX);
            }
        })) {
            this.loadCertificateFromFile(f);
        }
    }

    private void loadCertificateFromFile(File file) {
        this.certificateFileSanityChecks(file);
        try {
            X509Certificate aaCert = CertificateUtils.loadCertificate(new FileInputStream(file), CertificateUtils.Encoding.PEM);
            String aaCertHash = OpensslTrustAnchorStore.getOpenSSLCAHash(aaCert.getSubjectX500Principal());
            this.localAACertificatesByHash.put(aaCertHash, aaCert);
            this.listener.notifyCertificateLoadEvent(aaCert, file);
        }
        catch (IOException e) {
            String errorMessage = String.format("Error parsing VOMS trusted certificate from %s. Reason: %s", file.getAbsolutePath(), e.getMessage());
            throw new VOMSError(errorMessage, e);
        }
    }

    private void loadLSCFromDirectory(File directory) {
        this.directorySanityChecks(directory);
        this.listener.notifyLSCLookupEvent(directory.getAbsolutePath());
        File[] lscFiles = directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(DefaultVOMSTrustStore.LSC_FILENAME_SUFFIX);
            }
        });
        if (lscFiles.length == 0) {
            return;
        }
        DefaultLSCFileParser lscParser = new DefaultLSCFileParser();
        String voName = directory.getName();
        for (File lsc : lscFiles) {
            String lscFileName = lsc.getName();
            String hostname = lscFileName.substring(0, lscFileName.indexOf(LSC_FILENAME_SUFFIX));
            LSCFile info = null;
            info = lscParser.parse(voName, hostname, lsc);
            Set<LSCInfo> localLscForVo = this.localLSCInfo.get(voName);
            if (localLscForVo == null) {
                localLscForVo = new HashSet<LSCInfo>();
                this.localLSCInfo.put(voName, localLscForVo);
            }
            localLscForVo.add(info);
            this.listener.notifyLSCLoadEvent(info, lsc);
        }
    }

    private void certificateFileSanityChecks(File certFile) {
        if (!certFile.exists()) {
            throw new VOMSError("Local VOMS trusted certificate does not exist:" + certFile.getAbsolutePath());
        }
        if (!certFile.canRead()) {
            throw new VOMSError("Local VOMS trusted certificate is not readable:" + certFile.getAbsolutePath());
        }
    }

    private void directorySanityChecks(File directory) {
        if (!directory.exists()) {
            throw new VOMSError("Local trust directory does not exists:" + directory.getAbsolutePath());
        }
        if (!directory.isDirectory()) {
            throw new VOMSError("Local trust directory is not a directory:" + directory.getAbsolutePath());
        }
        if (!directory.canRead()) {
            throw new VOMSError("Local trust directory is not readable:" + directory.getAbsolutePath());
        }
        if (!directory.canExecute()) {
            throw new VOMSError("Local trust directory is not traversable:" + directory.getAbsolutePath());
        }
    }

    private void checkStoreIsNotEmpty() {
        if (this.localAACertificatesByHash.values().isEmpty() && this.localLSCInfo.values().isEmpty()) {
            throw new VOMSError("No VOMS trust information loaded from the given trust dirs: " + this.localTrustedDirs);
        }
    }

    private void cleanupStores() {
        this.localAACertificatesByHash.clear();
        this.localLSCInfo.clear();
    }

    @Override
    public synchronized void loadTrustInformation() {
        if (this.localTrustedDirs.isEmpty()) {
            throw new VOMSError("No local trust directory was specified for this trust store. Please provide at least one path where LSC and VOMS service certificates will be searched for.");
        }
        this.cleanupStores();
        for (String localDir : this.localTrustedDirs) {
            File[] voDirs;
            File baseTrustDir = new File(localDir);
            this.loadCertificatesFromDirectory(baseTrustDir);
            for (File voDir : voDirs = baseTrustDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })) {
                this.loadLSCFromDirectory(voDir);
                this.loadCertificatesFromDirectory(voDir);
            }
        }
        this.checkStoreIsNotEmpty();
    }

    @Override
    public synchronized X509Certificate getAACertificateBySubject(X500Principal aaCertSubject) {
        String theCertHash = OpensslTrustAnchorStore.getOpenSSLCAHash(aaCertSubject);
        return this.localAACertificatesByHash.get(theCertHash);
    }

    @Override
    public synchronized Map<String, Set<LSCInfo>> getAllLSCInfo() {
        return Collections.unmodifiableMap(this.localLSCInfo);
    }

    @Override
    public synchronized void setStatusListener(VOMSTrustStoreStatusListener statusListener) {
        this.listener = statusListener;
    }
}

